#ifndef ITAP_API_COMM_DEF_H
#define ITAP_API_COMM_DEF_H

#pragma pack(push, 1)

//=============================================================================
/**
 *	\addtogroup G_DATATYPE_CHARS	ַͶ
 *	@{
 */
//=============================================================================
namespace ITapTrade
{
    //! Ϊ10ַ
    typedef char	TAPISTR_10[11];
    //! Ϊ20ַ
    typedef char	TAPISTR_20[21];
    //! Ϊ30ַ
    typedef char	TAPISTR_30[31];
    //! Ϊ40ַ
    typedef char	TAPISTR_40[41];
    //! Ϊ50ַ
    typedef char	TAPISTR_50[51];
    //! Ϊ70ַ
    typedef char	TAPISTR_70[71];
    //! Ϊ100ַ
    typedef char	TAPISTR_100[101];
    //! Ϊ300ַ
    typedef char	TAPISTR_300[301];
    //! Ϊ500ַ
    typedef char	TAPISTR_500[501];
    //! Ϊ2000ַ
    typedef char	TAPISTR_2000[2001];

    //! Authorization Code
    typedef char	TAPIAUTHCODE[513];

    //! MACַ.
    typedef char	TAPIMACTYPE[13];
	//! ֤
	typedef char	TAPISecondSerialIDType[5];


    //! ַ壬ڶ
    typedef char				TAPICHAR;

	//˻
	typedef char	TAPIClientIDType[16];
    /** @}*/


    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_NUMBER	ֵͶ
     *	@{
     */
    //=============================================================================

    //! int 32
    typedef int					TAPIINT32;
    //! unsigned 32
    typedef unsigned int		TAPIUINT32;
    //! int 64
    typedef long long			TAPIINT64;
    //! unsigned 64
    typedef unsigned long long	TAPIUINT64;
    //! unsigned 16
    typedef unsigned short		TAPIUINT16;
    //! unsigned 8
    typedef unsigned char		TAPIUINT8;
    //! real 64
    typedef double				TAPIREAL64;

    /** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_YNFLAG	Ƿʾ
     *	@{
     */
    //=============================================================================
    //! Ƿʾ
    typedef TAPICHAR			TAPIYNFLAG;
    //! 
    const TAPIYNFLAG			APIYNFLAG_YES	='Y';
    //! 
    const TAPIYNFLAG			APIYNFLAG_NO	='N';

    /** @}*/

	//=============================================================================
	/**
	*	\addtogroup G_DATATYPE_PASSWORDTYEP	ͱʶ
	*	@{
	*/
	//=============================================================================
	//! 
	typedef TAPICHAR			TAPIPasswordType;
	//! 
	const TAPIPasswordType			APIPASSWORD_TRADE = 'T';
	//! 绰
	const TAPIPasswordType			APIPASSWORD_PHONE = 'P';

	/** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_DATETIME	ʱͶ
     *	@{
     */
    //=============================================================================

    //! ʱ(ʽ yyyy-MM-dd hh:nn:ss.xxx)
    typedef char	TAPIDTSTAMP[24];
    //! ںʱ(ʽ yyyy-MM-dd hh:nn:ss)
    typedef char	TAPIDATETIME[20];
    //! (ʽ yyyy-MM-dd)
    typedef char	TAPIDATE[11];
    //! ʱ(ʽ hh:nn:ss)
    typedef char	TAPITIME[9];
    /** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_LOG_LEVEL	־
     *	@{
     */
    //=============================================================================
    //! ־
    typedef TAPICHAR			TAPILOGLEVEL;
    //! 
    const TAPILOGLEVEL			APILOGLEVEL_NONE	='N';
    //! Error
    const TAPILOGLEVEL			APILOGLEVEL_ERROR	='E';
    //! Warning
    const TAPILOGLEVEL			APILOGLEVEL_WARNING	='W';
    //! Debug
    const TAPILOGLEVEL			APILOGLEVEL_DEBUG	='D';
    /** @}*/

	//=============================================================================
	/**
	*	\addtogroup G_DATATYPE_OPTION_TYPE	Ȩ
	*	@{
	*/
	//=============================================================================

	typedef TAPICHAR					TAPIOptionType;
	//!ʽȨ + Ȩʽ
	const TAPIOptionType				TAPI_OPTION_TYPE_AMERICAN = 'A';
	//!ʽȨ + ڻʽ
	const TAPIOptionType				TAPI_OPTION_TYPE_AMERICAN2 = 'B';
	//!ŷʽȨ + Ȩʽ
	const TAPIOptionType				TAPI_OPTION_TYPE_EUROPEAN = 'E';
	//!ŷʽȨ + ڻʽ
	const TAPIOptionType				TAPI_OPTION_TYPE_EUROPEAN2 = 'F';
	/** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_COMMODITY_TYPE	Ʒ
     *	@{
     */
    //=============================================================================

    //! Ʒ
    typedef TAPICHAR               TAPICommodityType;
    //! 
    const TAPICommodityType		TAPI_COMMODITY_TYPE_NONE				= 'N';
    //! ֻ
    const TAPICommodityType		TAPI_COMMODITY_TYPE_SPOT				= 'P';
    //! ڻ
    const TAPICommodityType		TAPI_COMMODITY_TYPE_FUTURES				= 'F';
    //! Ȩ
    const TAPICommodityType		TAPI_COMMODITY_TYPE_OPTION				= 'O';
    //! 
    const TAPICommodityType		TAPI_COMMODITY_TYPE_SPREAD_MONTH		= 'S';
    //! Ʒ
    const TAPICommodityType		TAPI_COMMODITY_TYPE_SPREAD_COMMODITY	= 'M';
    //! Ǵֱ
    const TAPICommodityType		TAPI_COMMODITY_TYPE_BUL					= 'U';
    //! ֱ
    const TAPICommodityType		TAPI_COMMODITY_TYPE_BER					= 'E';
    //! ʽ
    const TAPICommodityType		TAPI_COMMODITY_TYPE_STD					= 'D';
    //! ʽ
    const TAPICommodityType		TAPI_COMMODITY_TYPE_STG					= 'G';
    //! 
    const TAPICommodityType		TAPI_COMMODITY_TYPE_PRT					= 'R';
    //! 㡪ֱӻ
    const TAPICommodityType		TAPI_COMMODITY_TYPE_DIRECTFOREX			= 'X';
    //! 㡪ӻ
    const TAPICommodityType		TAPI_COMMODITY_TYPE_INDIRECTFOREX		= 'I';
    //! 㡪
    const TAPICommodityType		TAPI_COMMODITY_TYPE_CROSSFOREX			= 'C';
    //! ָ
    const TAPICommodityType		TAPI_COMMODITY_TYPE_INDEX				= 'Z';
    //! Ʊ
    const TAPICommodityType		TAPI_COMMODITY_TYPE_STOCK				= 'T';


    /** @}*/


    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_CALL_OR_PUT	ǿʾ
     *	@{
     */
    //=============================================================================

    //! ǿʾ
    typedef TAPICHAR			TAPICallOrPutFlagType;
    //! Ȩ
    const TAPICallOrPutFlagType		TAPI_CALLPUT_FLAG_CALL				= 'C';
    //! Ȩ
    const TAPICallOrPutFlagType		TAPI_CALLPUT_FLAG_PUT				= 'P';
    //! 
    const TAPICallOrPutFlagType		TAPI_CALLPUT_FLAG_NONE				= 'N';

    /** @}*/


    //! ApplicationϢ
    struct TapAPIApplicationInfo
    {
            TAPIAUTHCODE            AuthCode;								///< Ȩ
            TAPISTR_300				KeyOperationLogPath;					///< ؼ־· APIRun־
			TAPILOGLEVEL			LogLevel;								///< ־
    };


    //! Ʒֱṹ
    struct TapAPICommodity
    {
            TAPISTR_10              ExchangeNo;                             ///< 
            TAPICommodityType		CommodityType;                          ///< Ʒ
            TAPISTR_10				CommodityNo;                            ///< Ʒֱ
    };

    //! Լṹ
    struct TapAPIContract
    {
            TapAPICommodity			Commodity;								///< Ʒ
            TAPISTR_10				ContractNo1;                            ///< Լ1
            TAPISTR_10				StrikePrice1;                           ///< ִм1
            TAPICallOrPutFlagType	CallOrPutFlag1;                         ///< ǿʾ1
            TAPISTR_10				ContractNo2;                            ///< Լ2
            TAPISTR_10				StrikePrice2;                           ///< ִм2
            TAPICallOrPutFlagType	CallOrPutFlag2;                         ///< ǿʾ2

    };

    //! Ϣ
    struct TapAPIExchangeInfo
    {
            TAPISTR_10				ExchangeNo;								///< 
            TAPISTR_20				ExchangeName;							///< 
    };

    //! ޸
    struct TapAPIChangePasswordReq
    {
			TAPISTR_20					AccountNo;
			TAPIPasswordType			PasswordType;							///<
            TAPISTR_20					OldPassword;							///< 
            TAPISTR_20					NewPassword;							///< 
    };
	//!	֤
	struct TapAPIAuthPasswordReq
	{
		TAPISTR_20						AccountNo;								///<ͻ˺
		TAPIPasswordType				PasswordType;							///<
		TAPISTR_20						Password;								///<˻
	};


    #pragma pack(pop)
}
#endif