//ļTapTradeAPI ʹõͺݽṹ
#ifndef ITAP_TRADE_API_DATA_TYPE_H
#define ITAP_TRADE_API_DATA_TYPE_H
#include "iTapAPICommDef.h"
#include <memory.h>
namespace ITapTrade
{
#pragma pack(push, 1)


    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPIACCOUNTTYPE	˺
     *	@{
     */
    //=============================================================================
    //! ˺
    typedef TAPICHAR			TAPIAccountType;
    //! ˿ͻ
    const TAPIAccountType		TAPI_ACCOUNT_TYPE_PERSON				= 'P';
    //! ͻ
    const TAPIAccountType		TAPI_ACCOUNT_TYPE_ORGANIZATION		    = 'O';
    //! 
    const TAPIAccountType		TAPI_ACCOUNT_TYPE_AGENT = 'A';
    //!Margin
    const TAPIAccountType		TAPI_ACCOUNT_TYPE_MARGIN = 'M';
    //! Internal
    const TAPIAccountType		TAPI_ACCOUNT_TYPE_HOUSE = 'H';
    //! Ʊ˻
    const TAPIAccountType		TAPI_ACCOUNT_TYPE_STOCK = 'S';
    /** @}*/

    //=============================================================================
    /**
    *	\addtogroup G_DATATYPE_T_TAPIRIGHTIDTYPE	Ȩޱ
    *	@{
    */
    //=============================================================================
    //! Ȩޱ
    typedef TAPIINT32			TAPIRightIDType;
    //! ϵͳɾ
    const TAPIRightIDType		TAPI_RIGHT_ORDER_DEL	= 30001;
    //! 
    const TAPIRightIDType		TAPI_RIGHT_ORDER_CHECK	= 30002;
    //! ֻɲѯ
    const TAPIRightIDType		TAPI_RIGHT_ONLY_QRY		= 31000;
    //! ֻɿ
    const TAPIRightIDType		TAPI_RIGHT_ONLY_OPEN	= 31001;
    /** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPIUSERTYPETYPE	¼û
     *	@{
     */
    //=============================================================================
    //! ¼û
    typedef TAPIINT32			TAPIUserTypeType;
    //! Ͷû
    const TAPIUserTypeType		TAPI_USERTYPE_CLIENT					=10000;
    //! 
    const TAPIUserTypeType		TAPI_USERTYPE_BROKER					=20000;
    //! Ա
    const TAPIUserTypeType		TAPI_USERTYPE_TRADER					=30000;
    //! 
    const TAPIUserTypeType		TAPI_USERTYPE_RISK						=40000;
    //! Ա
    const TAPIUserTypeType		TAPI_USERTYPE_MANAGER					=50000;
    //! 
    const TAPIUserTypeType		TAPI_USERTYPE_QUOTE						=60000;
    /** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPIACCOUNTSTATE	˺״̬
     *	@{
     */
    //=============================================================================
    //! ˺״̬
    typedef TAPICHAR			TAPIAccountState;
    //! 
    const TAPIAccountState		TAPI_ACCOUNT_STATE_NORMAL				= 'N';
    //! 
    const TAPIAccountState		TAPI_ACCOUNT_STATE_CANCEL				= 'C';
    //! 
    const TAPIAccountState		TAPI_ACCOUNT_STATE_SLEEP				= 'S';
	//
	const TAPIAccountState		TAPI_ACCOUNT_STATE_FROZEN				= 'F';
    /** @}*/



    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPIACCOUNTRIGHTTYPE	˻״̬
     *	@{
     */
    //=============================================================================
    //! ͻ״̬
    typedef TAPICHAR			TAPIAccountRightType;
    //! 
    const	TAPIAccountRightType	TAPI_ACCOUNT_TRADING_RIGHT_NORMAL = '0';
    //! ֹ
    const	TAPIAccountRightType	TAPI_ACCOUNT_TRADING_RIGHT_NOTRADE = '1';
    //! ֻƽ
    const	TAPIAccountRightType	TAPI_ACCOUNT_TRADING_RIGHT_CLOSE = '2';
    /** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPIORDERTYPETYPE	ί
     *	@{
     */
    //=============================================================================
    //! ί
    typedef TAPICHAR				TAPIOrderTypeType;
    //! м
    const TAPIOrderTypeType			TAPI_ORDER_TYPE_MARKET				= '1';
    //! ޼
    const TAPIOrderTypeType			TAPI_ORDER_TYPE_LIMIT				= '2';
    //! мֹ
    const TAPIOrderTypeType			TAPI_ORDER_TYPE_STOP_MARKET			= '3';
    //! ޼ֹ
    const TAPIOrderTypeType			TAPI_ORDER_TYPE_STOP_LIMIT			= '4';
    //! ȨȨ
    const TAPIOrderTypeType			TAPI_ORDER_TYPE_OPT_EXEC			= '5';
    //! ȨȨ
    const TAPIOrderTypeType			TAPI_ORDER_TYPE_OPT_ABANDON			= '6';
    //! ѯ
    const TAPIOrderTypeType			TAPI_ORDER_TYPE_REQQUOT				= '7';
    //! Ӧ
    const TAPIOrderTypeType			TAPI_ORDER_TYPE_RSPQUOT				= '8';
    //! ɽ
	const TAPIOrderTypeType			TAPI_ORDER_TYPE_ICEBERG				= '9';
	//! Ӱӵ
	const TAPIOrderTypeType			TAPI_ORDER_TYPE_GHOST				= 'A';
	//۽۵
	const TAPIOrderTypeType			TAPI_ORDER_TYPE_HKEX_AUCTION		= 'B';
	//
	const TAPIOrderTypeType			TAPI_ORDER_TYPE_SWAP				= 'C';
	//֤ȯ
	const TAPIOrderTypeType			TAPI_ORDER_TYPE_LOCK				= 'D';
	//֤ȯ
	const TAPIOrderTypeType			TAPI_ORDER_TYPE_UNLOCK				= 'E';
	//ǿ޼۵
	const TAPIOrderTypeType			TAPI_ORDER_TYPE_ENHANCE				= 'F';
    /** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPIORDERSOURCETYPE	ίԴ
     *	@{
     */
    //=============================================================================
    //! ίԴ
    typedef TAPICHAR				TAPIOrderSourceType;
    //! ӵ
    const TAPIOrderSourceType		TAPI_ORDER_SOURCE_SELF_ETRADER			= '1';
    //! ӵ
    const TAPIOrderSourceType		TAPI_ORDER_SOURCE_PROXY_ETRADER			= '2';
    //! ⲿӵ(ⲿϵͳµϵͳ¼)
    const TAPIOrderSourceType		TAPI_ORDER_SOURCE_JTRADER				= '3';
    //! ˹¼뵥(ⲿʽµϵͳ¼)
    const TAPIOrderSourceType		TAPI_ORDER_SOURCE_MANUAL				= '4';
    //! carry
    const TAPIOrderSourceType		TAPI_ORDER_SOURCE_CARRY					= '5';
    //! ʽ
    const TAPIOrderSourceType		TAPI_ORDER_SOURCE_PROGRAM				= '6';
    //! Ȩ
    const TAPIOrderSourceType		TAPI_ORDER_SOURCE_DELIVERY				= '7';
    //! Ȩ
    const TAPIOrderSourceType		TAPI_ORDER_SOURCE_ABANDON				= '8';
    //! ͨ
    const TAPIOrderSourceType		TAPI_ORDER_SOURCE_CHANNEL				= '9';
    /** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPITIMEINFORCETYPE	ίЧ
     *	@{
     */
    //=============================================================================
    //! ίЧ
    typedef TAPICHAR				TAPITimeInForceType;
    //! Ч
    const TAPITimeInForceType		TAPI_ORDER_TIMEINFORCE_GFD					= '0';
    //! ȡǰЧ
    const TAPITimeInForceType		TAPI_ORDER_TIMEINFORCE_GTC					= '1';
    //! ָǰЧ
    const TAPITimeInForceType		TAPI_ORDER_TIMEINFORCE_GTD					= '2';
    //! FAKIOC
    const TAPITimeInForceType		TAPI_ORDER_TIMEINFORCE_FAK					= '3';
    //! FOK
    const TAPITimeInForceType		TAPI_ORDER_TIMEINFORCE_FOK					= '4';
    /** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPISIDETYPE	
     *	@{
     */
    //=============================================================================
    //! 
    typedef TAPICHAR				TAPISideType;
    //! 
    const TAPISideType				TAPI_SIDE_NONE							= 'N';
    //! 
    const TAPISideType				TAPI_SIDE_BUY							= 'B';
    //! 
    const TAPISideType				TAPI_SIDE_SELL							= 'S';
    /** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPIPOSITIONEFFECTTYPE	ƽ
     *	@{
     */
    //=============================================================================
    //! ƽ
    typedef TAPICHAR				TAPIPositionEffectType;
    //! ֿƽ
    const TAPIPositionEffectType	TAPI_PositionEffect_NONE				= 'N';
    //! 
    const TAPIPositionEffectType	TAPI_PositionEffect_OPEN				= 'O';
    //! ƽ
    const TAPIPositionEffectType	TAPI_PositionEffect_COVER			= 'C';
    //! ƽ
    const TAPIPositionEffectType	TAPI_PositionEffect_COVER_TODAY		= 'T';
    /** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPIHEDGEFLAGTYPE	Ͷֵ
     *	@{
     */
    //=============================================================================
    //! Ͷֵ
    typedef TAPICHAR				TAPIHedgeFlagType;
    //! 
    const TAPIHedgeFlagType			TAPI_HEDGEFLAG_NONE					= 'N';
    //! Ͷ
    const TAPIHedgeFlagType			TAPI_HEDGEFLAG_T					= 'T';
    //! ֵ
    const TAPIHedgeFlagType			TAPI_HEDGEFLAG_B					= 'B';
	//! 
	const TAPIHedgeFlagType			TAPI_HEDGEFLAG_R					= 'R';


    /** @}*/
    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPIORDERSTATETYPE	ί״̬
     *	@{
     */
    //=============================================================================
    //! ί״̬
    typedef TAPICHAR				TAPIOrderStateType;
    //! նύ
    const TAPIOrderStateType		TAPI_ORDER_STATE_SUBMIT				= '0';
    //! 
    const TAPIOrderStateType		TAPI_ORDER_STATE_ACCEPT				= '1';
    //! Դ
    const TAPIOrderStateType		TAPI_ORDER_STATE_TRIGGERING			= '2';
    //! 
    const TAPIOrderStateType		TAPI_ORDER_STATE_EXCTRIGGERING		= '3';
    //! Ŷ
    const TAPIOrderStateType		TAPI_ORDER_STATE_QUEUED				= '4';
    //! ֳɽ
    const TAPIOrderStateType		TAPI_ORDER_STATE_PARTFINISHED		= '5';
    //! ȫɽ
    const TAPIOrderStateType		TAPI_ORDER_STATE_FINISHED			= '6';
    //! (Ŷʱ״̬)
    const TAPIOrderStateType		TAPI_ORDER_STATE_CANCELING			= '7';
    //! ޸(Ŷʱ״̬)
    const TAPIOrderStateType		TAPI_ORDER_STATE_MODIFYING			= '8';
    //! ȫ
    const TAPIOrderStateType		TAPI_ORDER_STATE_CANCELED			= '9';
    //! ѳ൥
    const TAPIOrderStateType		TAPI_ORDER_STATE_LEFTDELETED		= 'A';
    //! ָʧ
    const TAPIOrderStateType		TAPI_ORDER_STATE_FAIL				= 'B';
    //! ɾ
    const TAPIOrderStateType		TAPI_ORDER_STATE_DELETED			= 'C';
    //! ѹ
    const TAPIOrderStateType		TAPI_ORDER_STATE_SUPPENDED			= 'D';
    //! ɾ
    const TAPIOrderStateType		TAPI_ORDER_STATE_DELETEDFOREXPIRE	= 'E';
    //! Чѯ۳ɹ
    const TAPIOrderStateType		TAPI_ORDER_STATE_EFFECT				= 'F';
    //! 롪ȨȨɹ
    const TAPIOrderStateType		TAPI_ORDER_STATE_APPLY				= 'G';
    /** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPICALCULATEMODETYPE	㷽ʽ
     *	@{
     */
    //=============================================================================
    //! 㷽ʽ
    typedef TAPICHAR               TAPICalculateModeType;
    
	//!+ѣ0.01ΪС0.01Ϊ磺0.001Ϊȡ1%
	const TAPICalculateModeType		TAPI_CALULATE_MODE_COMBINE				= '0';
	//! 
    const TAPICalculateModeType		TAPI_CALCULATE_MODE_PERCENTAGE          = '1';
    //! 
    const TAPICalculateModeType		TAPI_CALCULATE_MODE_QUOTA               = '2';
    //! ֵ	
    const TAPICalculateModeType		TAPI_CALCULATE_MODE_CHAPERCENTAGE		= '3';
    //! ֵ
    const TAPICalculateModeType		TAPI_CALCULATE_MODE_CHAQUOTA			= '4';
    //! ۿ
    const TAPICalculateModeType		TAPI_CALCULATE_MODE_DISCOUNT			= '5';
    /** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPIMATCHSOURCETYPE	ɽԴ
     *	@{
     */
    //=============================================================================
    //! ɽԴ
    typedef TAPICHAR				TAPIMatchSourceType;
    //! ȫ
    const TAPIMatchSourceType		TAPI_MATCH_SOURCE_ALL                   = '0';
    //! ӵ
    const TAPIMatchSourceType		TAPI_MATCH_SOURCE_SELF_ETRADER          = '1';
    //! ӵ
    const TAPIMatchSourceType		TAPI_MATCH_SOURCE_PROXY_ETRADER         = '2';
    //! ⲿӵ
    const TAPIMatchSourceType		TAPI_MATCH_SOURCE_JTRADER				= '3';
    //! ˹¼뵥
    const TAPIMatchSourceType		TAPI_MATCH_SOURCE_MANUAL				= '4';
    //! carry
    const TAPIMatchSourceType		TAPI_MATCH_SOURCE_CARRY					= '5';
    //! ʽ
    const TAPIMatchSourceType		TAPI_MATCH_SOURCE_PROGRAM				= '6';
    //! Ȩ
    const TAPIMatchSourceType		TAPI_MATCH_SOURCE_DELIVERY				= '7';
    //! Ȩ
    const TAPIMatchSourceType		TAPI_MATCH_SOURCE_ABANDON				= '8';
    //! ͨ
    const TAPIMatchSourceType		TAPI_MATCH_SOURCE_CHANNEL				= '9';
	//!Bloombergµ
	const TAPIMatchSourceType		TAPI_MATCH_SOURCE_BLOOMBERG				= 'B';
	//!ֻ
	const TAPIMatchSourceType		TAPI_MATCH_SOURCE_AUTOPHONE				= 'A';
	//!GiveUpɽ
	const TAPIMatchSourceType		TAPI_MATCH_SOURCE_GIVEUP				= 'C';
	//!Ȩɽ
	const TAPIMatchSourceType		TAPI_MATCH_SOURCE_EXERCISE				= 'E';

    /** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPIOPENCLOSEMODETYPE	ƽʽ
     *	@{
     */
    //=============================================================================
    //! ƽʽ
    typedef TAPICHAR				TAPIOpenCloseModeType;
    //! ֿƽ
    const TAPIOpenCloseModeType		TAPI_CLOSE_MODE_NONE				= 'N';
    //! ƽδ˽
    const TAPIOpenCloseModeType		TAPI_CLOSE_MODE_UNFINISHED			= 'U';
    //! ֺֿƽ
    const TAPIOpenCloseModeType		TAPI_CLOSE_MODE_OPENCOVER			= 'C';
    //! ֿ֡ƽֺƽ
    const TAPIOpenCloseModeType		TAPI_CLOSE_MODE_CLOSETODAY			= 'T';
    /** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPIFUTUREALGTYPE	ڻ㷨
     *	@{
     */
    //=============================================================================
    //! ڻ㷨
    typedef TAPICHAR				TAPIFutureAlgType;
    //! 
    const TAPIFutureAlgType			TAPI_FUTURES_ALG_ZHUBI                  = '1';
    //! 
    const TAPIFutureAlgType			TAPI_FUTURES_ALG_DINGSHI                = '2';
    /** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPIOPTIONALGTYPE	Ȩ㷨
     *	@{
     */
    //=============================================================================
    //! Ȩ㷨
    typedef TAPICHAR				TAPIOptionAlgType;
    //! ڻʽ
    const TAPIOptionAlgType         TAPI_OPTION_ALG_FUTURES                 = '1';
    //! Ȩʽ
    const TAPIOptionAlgType         TAPI_OPTION_ALG_OPTION                  = '2';
    /** @}*/



    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPIBANKACCOUNTLWFLAGTYPE	ұʶ
     *	@{
     */
    //=============================================================================
    //! ұʶ
    typedef TAPICHAR				TAPIBankAccountLWFlagType;
    //! ˻
    const TAPIBankAccountLWFlagType	TAPI_LWFlag_L					= 'L';
    //! ͻ˻
    const TAPIBankAccountLWFlagType	TAPI_LWFlag_W					= 'W';
    /** @}*/


    //=============================================================================
    /**
    *	\addtogroup G_DATATYPE_T_TAPICASHADJUSTTYPETYPE	ʽ
    *	@{
    */
    //=============================================================================
    //! ʽ
    typedef TAPICHAR						TAPICashAdjustTypeType;
    //! ѵ
    const TAPICashAdjustTypeType			TAPI_CASHINOUT_MODE_FEEADJUST = '0';
    //! ӯ
    const TAPICashAdjustTypeType			TAPI_CASHINOUT_MODE_YKADJUST = '1';
    //! Ѻʽ
    const TAPICashAdjustTypeType			TAPI_CASHINOUT_MODE_PLEDGE = '2';
    //! Ϣ
    const TAPICashAdjustTypeType			TAPI_CASHINOUT_MODE_INTERESTREVENUE = '3';
    //! ۷
    const TAPICashAdjustTypeType			TAPI_CASHINOUT_MODE_COLLECTIONCOST = '4';
    //! 
    const TAPICashAdjustTypeType			TAPI_CASHINOUT_MODE_OTHER = '5';
    //! ˾䲦
    const TAPICashAdjustTypeType			TAPI_CASHINOUT_MODE_COMPANY = '6';
    /** @}*/



    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPIMARGINCALCULATEMODETYPE	ڻ֤ʽ
     *	@{
     */
    //=============================================================================
    //! ڻ֤ʽ
    typedef TAPICHAR				TAPIMarginCalculateModeType;
    //! ֱ
    const TAPIMarginCalculateModeType TAPI_DEPOSITCALCULATE_MODE_FEN     = '1';
    //! 
    const TAPIMarginCalculateModeType TAPI_DEPOSITCALCULATE_MODE_SUO     = '2';
    /** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPIOPTIONMARGINCALCULATEMODETYPE	Ȩ֤ʽ
     *	@{
     */
    //=============================================================================
    //! Ȩ֤ʽ,ݴжϸƷȨúü㹫ʽ㱣֤
    typedef TAPICHAR				TAPIOptionMarginCalculateModeType;
    /** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPICMBDIRECTTYPE	Ϸ
     *	@{
     */
    //=============================================================================
    //! Ϸ,ƷϺԼ͵ڼͬ
    typedef TAPICHAR				TAPICmbDirectType;
    //! ͵һһ
    const TAPICmbDirectType         TAPI_CMB_DIRECT_FIRST                    = '1';
    //! ͵ڶһ
    const TAPICmbDirectType         TAPI_CMB_DIRECT_SECOND                   = '2';
    /** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPIDELIVERYMODETYPE	Ȩʽ
     *	@{
     */
    //=============================================================================
    //! Ȩʽ,ڻȨ˽ķʽ
    typedef TAPICHAR				TAPIDeliveryModeType;
    //! ʵｻ
    const TAPIDeliveryModeType		TAPI_DELIVERY_MODE_GOODS			= 'G';
    //! ֽ𽻸
    const TAPIDeliveryModeType		TAPI_DELIVERY_MODE_CASH				= 'C';
    //! ȨȨ
    const TAPIDeliveryModeType		TAPI_DELIVERY_MODE_EXECUTE			= 'E';
    //! Ȩ
    const TAPIDeliveryModeType		TAPI_DELIVERY_MODE_ABANDON			= 'A';
    //! ۽Ȩ
    const TAPIDeliveryModeType		TAPI_DELIVERY_MODE_HKF				= 'H';
    /** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPICONTRACTTYPETYPE	Լ
     *	@{
     */
    //=============================================================================
    //! Լ
    typedef TAPICHAR				TAPIContractTypeType;
    //! Լ
    const TAPIContractTypeType		TAPI_CONTRACT_TYPE_TRADEQUOTE		='1';
    //! Լ
    const TAPIContractTypeType		TAPI_CONTRACT_TYPE_QUOTE			='2';
    /** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPITACTICSTYPETYPE	Ե
     *	@{
     */
    //=============================================================================
    //! Ե
    typedef TAPICHAR					TAPITacticsTypeType;
    //! 
    const TAPITacticsTypeType			TAPI_TACTICS_TYPE_NONE				= 'N';
    //! Ԥ()
    const TAPITacticsTypeType			TAPI_TACTICS_TYPE_READY				= 'M';
    //! Զ
    const TAPITacticsTypeType			TAPI_TACTICS_TYPE_ATUO				= 'A';
    //! 
    const TAPITacticsTypeType			TAPI_TACTICS_TYPE_CONDITION			= 'C';
    /** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPIORDERACT	
     *	@{
     */
    //=============================================================================
    //! 
    typedef TAPICHAR		TAPIORDERACT;
    //! 
    const TAPIORDERACT APIORDER_INSERT			= '1';
    //! ĵ
    const TAPIORDERACT APIORDER_MODIFY			= '2';
    //! 
    const TAPIORDERACT APIORDER_DELETE			= '3';
    //! 
    const TAPIORDERACT APIORDER_SUSPEND			= '4';
    //! 
    const TAPIORDERACT APIORDER_ACTIVATE		= '5';
    //! ɾ
    const TAPIORDERACT APIORDER_SYSTEM_DELETE	= '6';
    /** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPITRIGGERCONDITIONTYPE	
     *	@{
     */
    //=============================================================================
    //! 
    typedef TAPICHAR				TAPITriggerConditionType;
    //! 
    const TAPITriggerConditionType	TAPI_TRIGGER_CONDITION_NONE			= 'N';
    //! ڵ
    const TAPITriggerConditionType	TAPI_TRIGGER_CONDITION_GREAT		= 'G';
    //! Сڵ
    const TAPITriggerConditionType	TAPI_TRIGGER_CONDITION_LITTLE		= 'L';
    /** @}*/

    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPITRIGGERPRICETYPETYPE	۸
     *	@{
     */
    //=============================================================================
    //! ۸
    typedef TAPICHAR				TAPITriggerPriceTypeType;
    //! 
    const TAPITriggerPriceTypeType	TAPI_TRIGGER_PRICE_NONE				= 'N';
    //! 
    const TAPITriggerPriceTypeType	TAPI_TRIGGER_PRICE_BUY				= 'B';
    //! 
    const TAPITriggerPriceTypeType	TAPI_TRIGGER_PRICE_SELL				= 'S';
    //! ¼
    const TAPITriggerPriceTypeType	TAPI_TRIGGER_PRICE_LAST				= 'L';
    /** @}*/


    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPITRADINGSTATETYPE	״̬
     *	@{
     */
    //=============================================================================
    //! ״̬
    typedef TAPICHAR               TAPITradingStateType;
    //! Ͼ
    const TAPITradingStateType      TAPI_TRADE_STATE_BID                = '1';
    //! Ͼ۴
    const TAPITradingStateType      TAPI_TRADE_STATE_MATCH              = '2';
    //! 
    const TAPITradingStateType      TAPI_TRADE_STATE_CONTINUOUS         = '3';
    //! ͣ
    const TAPITradingStateType      TAPI_TRADE_STATE_PAUSED             = '4';
    //! 
    const TAPITradingStateType      TAPI_TRADE_STATE_CLOSE              = '5';
    //! дʱ
    const TAPITradingStateType      TAPI_TRADE_STATE_DEALLAST           = '6';
    //! δ
    const TAPITradingStateType		TAPI_TRADE_STATE_GWDISCONNECT		= '0';
    //! δ֪״̬
    const TAPITradingStateType		TAPI_TRADE_STATE_UNKNOWN			= 'N';
    //! ʼ
    const TAPITradingStateType		TAPI_TRADE_STATE_INITIALIZE			= 'I';
    //! ׼
    const TAPITradingStateType		TAPI_TRADE_STATE_READY				= 'R';
    /** @}*/



    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPINOTICEIGNOREFLAGTYPE	Ժ̨֪ͨ
     *	@{
     */
    //=============================================================================
    //! Ժ̨֪ͨ
    typedef TAPIUINT32              TAPINoticeIgnoreFlagType;
    //! Ϣ
    const TAPINoticeIgnoreFlagType TAPI_NOTICE_IGNORE_NONE				= 0x00000000;
    //! 
    const TAPINoticeIgnoreFlagType TAPI_NOTICE_IGNORE_ALL				= 0xFFFFFFFF;
    //! ʽ:OnRtnFund
    const TAPINoticeIgnoreFlagType TAPI_NOTICE_IGNORE_FUND				= 0x00000001;
    //! ί:OnRtnOrder
    const TAPINoticeIgnoreFlagType TAPI_NOTICE_IGNORE_ORDER				= 0x00000002;
    //! Գɽ:OnRtnFill
    const TAPINoticeIgnoreFlagType TAPI_NOTICE_IGNORE_FILL				= 0x00000004;
    //! Գֲ:OnRtnPosition
    const TAPINoticeIgnoreFlagType TAPI_NOTICE_IGNORE_POSITION			= 0x00000008;
    //! ƽ:OnRtnClose
    const TAPINoticeIgnoreFlagType TAPI_NOTICE_IGNORE_CLOSE				= 0x00000010;
    //! Գֲӯ:OnRtnPositionProfit
    const TAPINoticeIgnoreFlagType TAPI_NOTICE_IGNORE_POSITIONPROFIT	= 0x00000020;
    /** @}*/


    //=============================================================================
    /**
     *	\addtogroup G_DATATYPE_T_TAPIORDERQRYTYPETYPE	ίвѯ
     *	@{
     */
    //=============================================================================
    //! ίвѯ
    typedef TAPICHAR              TAPIOrderQryTypeType;
    //! ί
    const TAPIOrderQryTypeType TAPI_ORDER_QRY_TYPE_ALL				= 'A';
    //! ֻδί
    const TAPIOrderQryTypeType TAPI_ORDER_QRY_TYPE_UNENDED			= 'U';
    /** @}*/

	//=============================================================================
	/**
	 *	\addtogroup G_DATATYPE_T_CONTACTINFO	֤¼
	 *	@{
	 */
	 //=============================================================================
	//! ֤¼
	typedef TAPICHAR					TAPILoginTypeType;
	//! ¼θ豸
	const TAPILoginTypeType				TAPI_LOGINTYPE_NORMAL		= 'N';
	//! ʱ¼
	const TAPILoginTypeType				TAPI_LOGINTYPE_TEMPORARY	= 'T';
	/** @}*/
    //! ------------------------------------------------------------------------------------------

    //! ¼֤Ϣ
    struct TapAPITradeLoginAuth
    {
            TAPISTR_20					UserNo;					///< û
            TAPIYNFLAG					ISModifyPassword;		///< Ƿ޸	
            TAPISTR_20					Password;				///< 
            TAPISTR_20					NewPassword;			///< 
    };

    //! ¼Ϣ
    struct TapAPITradeLoginRspInfo
    {
            TAPISTR_20					UserNo;							///< û
            TAPIUserTypeType			UserType;						///< û
            TAPISTR_20					UserName;						///< û
            TAPISTR_50					ReservedInfo;					///< ԤϢ
            TAPISTR_40					LastLoginIP;					///< ϴε¼IP
            TAPIUINT32					LastLoginProt;					///< ϴε¼˿
            TAPIDATETIME				LastLoginTime;					///< ϴε¼ʱ
            TAPIDATETIME				LastLogoutTime;					///< ϴ˳ʱ
            TAPIDATE					TradeDate;						///< ǰ
            TAPIDATETIME				LastSettleTime;					///< ϴνʱ
            TAPIDATETIME				StartTime;						///< ϵͳʱ
            TAPIDATETIME				NextSecondDate;					///< ´ζ֤
    };
	//!֤ȨӦ
	struct  TapAPIRequestVertificateCodeRsp
	{
		TAPISecondSerialIDType SecondSerialID;							///< ֤Ȩ
		TAPIINT32 Effective;											///< ֤ȨЧڣ֣
	};

	//!֤֤ṹ
	struct TapAPISecondCertificationReq
	{
		TAPISTR_10							VertificateCode;		///<֤
		TAPILoginTypeType					LoginType;				///<֤¼
	};

    //! ˺Ϣѯ
    struct TapAPIAccQryReq
    {
    };

    //! ʽ˺Ϣ
    struct TapAPIAccountInfo
    {
            TAPISTR_20              AccountNo;                              ///< ʽ˺
            TAPIAccountType			AccountType;                            ///< ˺
            TAPIAccountState		AccountState;                           ///< ˺״̬
            TAPIAccountRightType		AccountTradeRight;					///<״̬
            TAPISTR_10				CommodityGroupNo;						///<ɽƷ.
            TAPISTR_20				AccountShortName;                       ///< ˺ż
            TAPISTR_20				AccountEnShortName;						///<˺Ӣļ
    };

    //! ͻµṹ
    struct TapAPINewOrder
    {
            TAPISTR_20					AccountNo;						///< ͻʽʺţ

            TAPISTR_10					ExchangeNo;						///< ţ
            TAPICommodityType			CommodityType;					///< Ʒͣ
            TAPISTR_10					CommodityNo;					///< Ʒֱͣ
            TAPISTR_10					ContractNo;						///< Լ1
            TAPISTR_10					StrikePrice;					///< ִм۸1Ȩд
            TAPICallOrPutFlagType		CallOrPutFlag;					///< ſ1 ĬN
            TAPISTR_10					ContractNo2;					///< Լ2ĬϿ
            TAPISTR_10					StrikePrice2;					///< ִм۸2ĬϿ
            TAPICallOrPutFlagType		CallOrPutFlag2;					///< ſ2 ĬN

            TAPIOrderTypeType			OrderType;						///< ί 
            TAPIOrderSourceType			OrderSource;					///< ίԴĬϳ򵥡
            TAPITimeInForceType			TimeInForce;					///< ίЧ,ĬϵЧ
            TAPIDATETIME				ExpireTime;						///< Ч(GTDʹ)

            TAPIYNFLAG					IsRiskOrder;					///< ǷձĬϷǷձ
            TAPISideType				OrderSide;						///< 
            TAPIPositionEffectType		PositionEffect;					///< ƽ־1,ĬN
            TAPIPositionEffectType		PositionEffect2;				///< ƽ־2ĬN
            TAPISTR_50					InquiryNo;						///< ѯۺ
            TAPIHedgeFlagType			HedgeFlag;						///< ͶֵĬN
            TAPIREAL64					OrderPrice;						///< ίм۸1
            TAPIREAL64					OrderPrice2;					///< ίм۸2Ӧʹ
            TAPIREAL64					StopPrice;						///< ۸
            TAPIUINT32					OrderQty;						///< ί
            TAPIUINT32					OrderMinQty;					///< СɽĬ1

            TAPIUINT32					MinClipSize;					///< ɽС
            TAPIUINT32					MaxClipSize;					///< ɽ

            TAPIINT32					RefInt;							///< Ͳοֵ
            TAPIREAL64					RefDouble;						///< οֵ
            TAPISTR_50					RefString;						///< ַοֵ

			TAPIClientIDType			ClientID;						///< ͻ˺ţ˺ţϱ˺
            TAPITacticsTypeType			TacticsType;					///< ԵͣĬN
            TAPITriggerConditionType	TriggerCondition;				///< ĬN
            TAPITriggerPriceTypeType	TriggerPriceType;				///< ۸ͣĬN
            TAPIYNFLAG					AddOneIsValid;					///< ǷT+1Ч,ĬT+1Ч
	public:
		TapAPINewOrder()
		{
			memset(this, 0, sizeof(TapAPINewOrder));
			CallOrPutFlag = TAPI_CALLPUT_FLAG_NONE;
			CallOrPutFlag2 = TAPI_CALLPUT_FLAG_NONE;
			OrderSource = TAPI_ORDER_SOURCE_PROGRAM;
			TimeInForce=TAPI_ORDER_TIMEINFORCE_GFD;
			IsRiskOrder = APIYNFLAG_NO;
			PositionEffect = TAPI_PositionEffect_NONE;
			PositionEffect2 = TAPI_PositionEffect_NONE;
			HedgeFlag = TAPI_HEDGEFLAG_NONE;
			OrderMinQty = 1;
			TacticsType = TAPI_TACTICS_TYPE_NONE;
			TriggerCondition = TAPI_TRIGGER_CONDITION_NONE;
			TriggerPriceType = TAPI_TRIGGER_PRICE_NONE;
			AddOneIsValid = APIYNFLAG_YES;
		}
    };


    //! ίϢ
    struct TapAPIOrderInfo
    {
            TAPISTR_20					AccountNo;						///< ͻʽʺ

            TAPISTR_10					ExchangeNo;						///< 
            TAPICommodityType			CommodityType;					///< Ʒ
            TAPISTR_10					CommodityNo;					///< Ʒֱ
            TAPISTR_10					ContractNo;						///< Լ1
            TAPISTR_10					StrikePrice;					///< ִм۸1
            TAPICallOrPutFlagType		CallOrPutFlag;					///< ſ1
            TAPISTR_10					ContractNo2;					///< Լ2
            TAPISTR_10					StrikePrice2;					///< ִм۸2
            TAPICallOrPutFlagType		CallOrPutFlag2;					///< ſ2

            TAPIOrderTypeType			OrderType;						///< ί
            TAPIOrderSourceType			OrderSource;					///< ίԴ
            TAPITimeInForceType			TimeInForce;					///< ίЧ
            TAPIDATETIME				ExpireTime;						///< Ч(GTDʹ)

            TAPIYNFLAG					IsRiskOrder;					///< Ƿձ
            TAPISideType				OrderSide;						///< 
            TAPIPositionEffectType		PositionEffect;					///< ƽ־1
            TAPIPositionEffectType		PositionEffect2;				///< ƽ־2
            TAPISTR_50					InquiryNo;						///< ѯۺ
            TAPIHedgeFlagType			HedgeFlag;						///< Ͷֵ
            TAPIREAL64					OrderPrice;						///< ίм۸1
            TAPIREAL64					OrderPrice2;					///< ίм۸2Ӧʹ
            TAPIREAL64					StopPrice;						///< ۸
            TAPIUINT32					OrderQty;						///< ί
            TAPIUINT32					OrderMinQty;					///< Сɽ

            TAPIINT32					RefInt;							///< Ͳοֵ
            TAPIREAL64					RefDouble;						///< οֵ
            TAPISTR_50					RefString;						///< ַοֵ

            TAPIUINT32					MinClipSize;					///< ɽС
            TAPIUINT32					MaxClipSize;					///< ɽ
            TAPISTR_50					LicenseNo;						///< Ȩ



            TAPICHAR					ServerFlag;						///< ʶ
            TAPISTR_20					OrderNo;						///< ίб
            TAPISTR_50                  ClientOrderNo;					///< ͻ˱ίб
			TAPIClientIDType            ClientID;						///< ͻ˺.
            TAPITacticsTypeType			TacticsType;					///< Ե
            TAPITriggerConditionType	TriggerCondition;				///< 
            TAPITriggerPriceTypeType	TriggerPriceType;				///< ۸
            TAPIYNFLAG					AddOneIsValid;					///< ǷT+1Ч

            TAPISTR_40					ClientLocalIP;					///< ն˱IP
            TAPIMACTYPE					ClientMac;						///< ն˱Macַ
            TAPISTR_40					ClientIP;						///< նַ.

            TAPIUINT32					OrderStreamID;					///< ίˮ
            TAPISTR_10					UpperNo;						///< ֺ
            TAPISTR_10					UpperChannelNo;					///< ͨ

            TAPISTR_20					OrderLocalNo;					///< غ
            TAPIUINT32					UpperStreamID;					///< 

            TAPISTR_50					OrderSystemNo;					///< ϵͳ
            TAPISTR_50					OrderExchangeSystemNo;			///< ϵͳ 
            TAPISTR_50					OrderParentSystemNo;			///< ϵͳ

            TAPISTR_20					OrderInsertUserNo;				///< µ
            TAPIDATETIME				OrderInsertTime;				///< µʱ
            TAPISTR_20					OrderCommandUserNo;				///< ¼
            TAPISTR_20					OrderUpdateUserNo;				///< ίи
            TAPIDATETIME				OrderUpdateTime;				///< ίиʱ

            TAPIOrderStateType			OrderState;						///< ί״̬

            TAPIREAL64					OrderMatchPrice;				///< ɽ1
            TAPIREAL64					OrderMatchPrice2;				///< ɽ2
            TAPIUINT32					OrderMatchQty;					///< ɽ1
            TAPIUINT32					OrderMatchQty2;					///< ɽ2

            TAPIUINT32					ErrorCode;						///< һβϢ
            TAPISTR_50					ErrorText;						///< Ϣ

            TAPIYNFLAG					IsBackInput;					///< ǷΪ¼ίе
            TAPIYNFLAG					IsDeleted;						///< ίгɽɾ
            TAPIYNFLAG					IsAddOne;						///< ǷΪT+1

    };

    //! ֪ͨṹ
    struct TapAPIOrderInfoNotice
    {
            TAPIUINT32					SessionID;						///< ỰID
            TAPIUINT32					ErrorCode; 						///< 
            TapAPIOrderInfo*			OrderInfo;						///< ίϢ
    };

    //! Ӧṹ
    struct TapAPIOrderActionRsp
    {
            TAPIORDERACT				ActionType;						///< 
            TapAPIOrderInfo*			OrderInfo;						///< ίϢ
    };


    //! ͻĵ
	//!ServerFlagOrderNo,Լίмۺίֶֹۡûá
    struct TapAPIAmendOrder
    {
        TapAPINewOrder              ReqData;                        ///< 
        TAPICHAR					ServerFlag;						///< ʶ
        TAPISTR_20                  OrderNo;                        ///< ίб
	public:
		TapAPIAmendOrder()
		{
			memset(this, 0, sizeof(TapAPIAmendOrder));
		}
    };

    //! ͻṹ
	//!ServerFlagOrderNo.
    struct TapAPIOrderCancelReq
    {
            TAPIINT32					RefInt;							///< Ͳοֵ
            TAPIREAL64					RefDouble;						///< οֵ
            TAPISTR_50					RefString;						///< ַοֵ
            TAPICHAR					ServerFlag;						///< ʶ
            TAPISTR_20					OrderNo;						///< ίб
    };

    //! ίṹ
    typedef TapAPIOrderCancelReq TapAPIOrderDeactivateReq;

    //! ίṹ
    typedef TapAPIOrderCancelReq TapAPIOrderActivateReq;

    //! ɾίṹ
    typedef TapAPIOrderCancelReq TapAPIOrderDeleteReq;

    //! ίвѯṹ
    struct TapAPIOrderQryReq
    {
            TAPISTR_20					AccountNo;						///< ʽ˺

            TAPISTR_10					ExchangeNo;						///< 
            TAPICommodityType			CommodityType;					///< Ʒ
            TAPISTR_10					CommodityNo;					///< Ʒֱ
            TAPIOrderTypeType			OrderType;						///< ί
            TAPIOrderSourceType			OrderSource;					///< ίԴ
            TAPITimeInForceType			TimeInForce;					///< ίЧ
            TAPIDATETIME				ExpireTime;						///< Ч(GTDʹ)

            TAPIYNFLAG					IsRiskOrder;					///< Ƿձ

            TAPICHAR					ServerFlag;						///< ʶ
            TAPISTR_20                  OrderNo;                        ///< ίб

            TAPIYNFLAG					IsBackInput;					///< ǷΪ¼ίе
            TAPIYNFLAG					IsDeleted;						///< ίгɽɾ
            TAPIYNFLAG					IsAddOne;						///< ǷΪT+1
    };

    //! ί̲ѯ
    struct TapAPIOrderProcessQryReq
    {
            TAPICHAR					ServerFlag;						///< ʶ
            TAPISTR_20					OrderNo;						///< ίб
    };

    //! ɽѯṹ
	struct TapAPIFillQryReq
	{
		TAPISTR_20					AccountNo;						///< ͻʽʺ

		TAPISTR_10					ExchangeNo;						///< 
		TAPICommodityType			CommodityType;					///< Ʒ
		TAPISTR_10					CommodityNo;					///< Ʒֱ
		TAPISTR_10					ContractNo;						///< Լ1
		TAPISTR_10					StrikePrice;					///< ִм۸
		TAPICallOrPutFlagType		CallOrPutFlag;					///< ſ

		TAPIMatchSourceType			MatchSource;					///< ίԴ
		TAPISideType				MatchSide;						///< 
		TAPIPositionEffectType              PositionEffect;					///< ƽ־1

		TAPICHAR					ServerFlag;						///< ʶ
		TAPISTR_20					OrderNo;						///< ίб
		TAPISTR_10					UpperNo;						///< ֺ
		TAPIYNFLAG					IsDeleted;						///< ίгɽɾ
		TAPIYNFLAG					IsAddOne;						///< ǷΪT+1
	};

    //! ɽϢ
    struct TapAPIFillInfo
    {
            TAPISTR_20					AccountNo;						///< ͻʽʺ

            TAPISTR_10					ExchangeNo;						///< 
            TAPICommodityType			CommodityType;					///< Ʒ
            TAPISTR_10					CommodityNo;					///< Ʒֱ
            TAPISTR_10					ContractNo;						///< Լ1
            TAPISTR_10					StrikePrice;					///< ִм۸
            TAPICallOrPutFlagType		CallOrPutFlag;					///< ſ

            TAPIMatchSourceType			MatchSource;					///< ίԴ
            TAPISideType				MatchSide;						///< 
            TAPIPositionEffectType              PositionEffect;					///< ƽ־1

            TAPICHAR					ServerFlag;						///< ʶ
            TAPISTR_20					OrderNo;						///< ίб
            TAPISTR_50					OrderSystemNo;					///< ϵͳ

            TAPISTR_20					MatchNo;						///< سɽ
            TAPISTR_70					UpperMatchNo;					///< ֳɽ
            TAPISTR_70					ExchangeMatchNo;				///< ɽ

            TAPIDATETIME				MatchDateTime;					///< ɽʱ
            TAPIDATETIME				UpperMatchDateTime;				///< ֳɽʱ

            TAPISTR_10					UpperNo;						///< ֺ

            TAPIREAL64					MatchPrice;						///< ɽ
            TAPIUINT32					MatchQty;						///< ɽ

            TAPIYNFLAG					IsDeleted;						///< ίгɽɾ
            TAPIYNFLAG					IsAddOne;						///< ǷΪT+1

            TAPISTR_10					FeeCurrencyGroup;				///< ͻѱ
            TAPISTR_10					FeeCurrency;					///< ͻѱ
            TAPIREAL64					FeeValue;						///< 
            TAPIYNFLAG					IsManualFee;					///< ˹ͻѱ

            TAPIREAL64					ClosePrositionPrice;					///< ָ۸ƽ
    };

    //! ƽֲѯṹ
    struct TapAPICloseQryReq
    {
            TAPISTR_20					AccountNo;						///< ͻʽʺ

            TAPISTR_10					ExchangeNo;						///< 
            TAPICommodityType			CommodityType;					///< Ʒ
            TAPISTR_10					CommodityNo;					///< Ʒֱ
    };

    //! ƽϢ
    struct TapAPICloseInfo
    {
            TAPISTR_20					AccountNo;						///< ͻʽʺ

            TAPISTR_10					ExchangeNo;						///< 
            TAPICommodityType			CommodityType;					///< Ʒ
            TAPISTR_10					CommodityNo;					///< Ʒֱ
            TAPISTR_10					ContractNo;						///< Լ
            TAPISTR_10					StrikePrice;					///< ִм۸
            TAPICallOrPutFlagType		CallOrPutFlag;					///< ſ

            TAPISideType				CloseSide;						///< ƽһߵ
            TAPIUINT32					CloseQty;						///< ƽֳɽ
            TAPIREAL64					OpenPrice;						///< ֳɽ
            TAPIREAL64					ClosePrice;						///< ƽֳɽ

            TAPISTR_20					OpenMatchNo;					///< سɽ
            TAPIDATETIME				OpenMatchDateTime;				///< ɽʱ
            TAPISTR_20					CloseMatchNo;					///< سɽ
            TAPIDATETIME				CloseMatchDateTime;				///< ɽʱ

            TAPIUINT32                  CloseStreamId;					///< ƽ

            TAPISTR_10					CommodityCurrencyGroup;			///< Ʒֱ
            TAPISTR_10					CommodityCurrency;				///< Ʒֱ

            TAPIREAL64					CloseProfit;					///< ƽӯ
    };

    //! ֲֲѯṹ
    struct TapAPIPositionQryReq
    {
            TAPISTR_20 AccountNo;
    };



    //! ֲϢ
    struct TapAPIPositionInfo
    {
            TAPISTR_20					AccountNo;						///< ͻʽʺ

            TAPISTR_10					ExchangeNo;						///< 
            TAPICommodityType			CommodityType;					///< Ʒ
            TAPISTR_10					CommodityNo;					///< Ʒֱ
            TAPISTR_10					ContractNo;						///< Լ1
            TAPISTR_10					StrikePrice;					///< ִм۸
            TAPICallOrPutFlagType		CallOrPutFlag;					///< ſ

            TAPISideType				MatchSide;						///< 
            TAPIHedgeFlagType			HedgeFlag;						///< Ͷֵ

            TAPISTR_70					PositionNo;						///< سֲֺţд

            TAPICHAR					ServerFlag;						///< ʶ
            TAPISTR_20					OrderNo;						///< ίб
            TAPISTR_20					MatchNo;						///< سɽ
            TAPISTR_10					UpperNo;						///< ֺ


            TAPIREAL64					PositionPrice;					///< ֲּ
            TAPIUINT32					PositionQty;					///< ֲ

        TAPIUINT32                  PositionStreamId;				///< ֲ

            TAPISTR_10					CommodityCurrencyGroup;			///< Ʒֱ
            TAPISTR_10					CommodityCurrency;				///< Ʒֱ

            TAPIREAL64					CalculatePrice;					///< ǰ۸

            TAPIREAL64					AccountInitialMargin;			///< ͻʼ֤
            TAPIREAL64					AccountMaintenanceMargin;		///< ͻάֱ֤
            TAPIREAL64					UpperInitialMargin;				///< ֳʼ֤
            TAPIREAL64					UpperMaintenanceMargin;			///< άֱ֤

            TAPIREAL64					PositionProfit;					///< ֲӯ
            TAPIREAL64					LMEPositionProfit;				///< LMEֲӯ
            TAPIREAL64					OptionMarketValue;				///< Ȩֵ
			TAPIYNFLAG					IsHistory;						///< ǷΪ֡
    };

    //! ͻֲӯ
    struct TapAPIPositionProfit
    {
            TAPISTR_70					PositionNo;						///< سֲֺţд
            TAPIUINT32					PositionStreamId;				///< ֲ
            TAPIREAL64					PositionProfit;					///< ֲӯ
            TAPIREAL64					LMEPositionProfit;				///< LMEֲӯ
            TAPIREAL64					OptionMarketValue;				///< Ȩֵ
            TAPIREAL64					CalculatePrice;					///< ۸
    };

    //! ͻֲӯ֪ͨ
    struct TapAPIPositionProfitNotice
    {
            TAPIYNFLAG					IsLast;							///< Ƿһ
            TapAPIPositionProfit*		Data;							///< ͻֲӯϢ
    };

	struct TapAPIPositionSummary
	{
		TAPISTR_20					AccountNo;						///< ͻʽʺ

		TAPISTR_10					ExchangeNo;						///< 
		TAPICommodityType			CommodityType;					///< Ʒ
		TAPISTR_10					CommodityNo;					///< Ʒֱ
		TAPISTR_10					ContractNo;						///< Լ1
		TAPISTR_10					StrikePrice;					///< ִм۸
		TAPICallOrPutFlagType		CallOrPutFlag;					///< ſ

		TAPISideType				MatchSide;						///< 
		TAPIREAL64					PositionPrice;					///< ֲ־ۡ
		TAPIUINT32					PositionQty;					///< ֲ
		TAPIUINT32					HisPositionQty;					///< ʷֲ
	};



    //! ʽѯ
    struct TapAPIFundReq
    {
            TAPISTR_20					AccountNo;						///< ͻʽʺ
    };
    //! ʽ˺ʽϢ
    struct TapAPIFundData
    {
            TAPISTR_20					AccountNo;						///< ͻʽ˺

            TAPISTR_10					CurrencyGroupNo;				///< 
            TAPISTR_10					CurrencyNo;						///< ֺ(Ϊձʾʽ)
            TAPIREAL64					TradeRate;						///< ׻
            TAPIFutureAlgType			FutureAlg;                      ///< ڻ㷨
            TAPIOptionAlgType			OptionAlg;                      ///< Ȩ㷨

            TAPIREAL64					PreBalance;						///< ս
            TAPIREAL64					PreUnExpProfit;					///< δƽӯ
            TAPIREAL64					PreLMEPositionProfit;			///< LMEֲƽӯ
            TAPIREAL64					PreEquity;						///< Ȩ
            TAPIREAL64					PreAvailable1;					///< տ
            TAPIREAL64					PreMarketEquity;				///< ֵȨ

            TAPIREAL64					CashInValue;					///< 
            TAPIREAL64					CashOutValue;					///< 
            TAPIREAL64					CashAdjustValue;				///< ʽ
            TAPIREAL64					CashPledged;					///< Ѻʽ
            TAPIREAL64					FrozenFee;						///< 
            TAPIREAL64					FrozenDeposit;					///< ᱣ֤
            TAPIREAL64					AccountFee;						///< ͻѰ
            TAPIREAL64					SwapInValue;					///< ʽ
            TAPIREAL64					SwapOutValue;					///< ʽ
            TAPIREAL64					PremiumIncome;					///< Ȩȡ
            TAPIREAL64					PremiumPay;						///< Ȩ֧
            TAPIREAL64					CloseProfit;					///< ƽӯ
            TAPIREAL64					FrozenFund;						///< ʽ
            TAPIREAL64					UnExpProfit;					///< δƽӯ
            TAPIREAL64					ExpProfit;						///< ƽӯ
            TAPIREAL64					PositionProfit;					///< LMEֲӯ
            TAPIREAL64					LmePositionProfit;				///< LMEֲӯ
            TAPIREAL64					OptionMarketValue;				///< Ȩֵ
            TAPIREAL64					AccountIntialMargin;			///< ͻʼ֤
            TAPIREAL64					AccountMaintenanceMargin;		///< ͻάֱ֤
            TAPIREAL64					UpperInitalMargin;				///< ֳʼ֤
            TAPIREAL64					UpperMaintenanceMargin;			///< άֱ֤
            TAPIREAL64					Discount;						///< LME

            TAPIREAL64					Balance;						///< ս
            TAPIREAL64					Equity;							///< Ȩ
            TAPIREAL64					Available;						///< տ
            TAPIREAL64					CanDraw;						///< ȡ
            TAPIREAL64					MarketEquity;					///< ˻ֵ
            TAPIREAL64					AuthMoney;                      ///< ʽ
    };

    //! ƷϢ
    struct TapAPICommodityInfo
    {
			TAPISTR_10							ExchangeNo;						//
			TAPICommodityType					CommodityType;					//Ʒ
			TAPISTR_10							CommodityNo;					//Ʒֱ

			TAPISTR_20							CommodityName;					//Ʒ
			TAPISTR_30							CommodityEngName;				//ƷӢ

			TAPISTR_10							RelateExchangeNo;
			TAPICommodityType					RelateCommodityType;
			TAPISTR_10							RelateCommodityNo;

			TAPISTR_10							RelateExchangeNo2;
			TAPICommodityType					RelateCommodityType2;
			TAPISTR_10							RelateCommodityNo2;

			TAPISTR_10							CurrencyGroupNo;
			TAPISTR_10							TradeCurrency;					//ױ
			TAPIREAL64							ContractSize;					//ÿֳ
			TAPIOpenCloseModeType				OpenCloseMode;					//ƽʽ
			TAPIREAL64							StrikePriceTimes;				//ִм۸

			TAPIREAL64							CommodityTickSize;				//С䶯λ
			TAPIINT32							CommodityDenominator;			//۷ĸ
			TAPICmbDirectType					CmbDirect;						//Ϸ
			TAPIDeliveryModeType				DeliveryMode;					//Ȩʽ
			TAPIINT32							DeliveryDays;					//ƫ
			TAPITIME							AddOneTime;						//T+1ָʱ
			TAPIINT32							CommodityTimeZone;				//Ʒʱ
			TAPIYNFLAG							IsAddOne;						//ǷT+1ʱΡ


    };

    //! ׺ԼϢ
    struct TapAPITradeContractInfo
    {
            TAPISTR_10              ExchangeNo;                             ///< 
            TAPICommodityType		CommodityType;                          ///< Ʒ
            TAPISTR_10              CommodityNo;                            ///< Ʒֱ
            TAPISTR_10              ContractNo1;                            ///< Լ1
            TAPISTR_10              StrikePrice1;                           ///< ִм1
            TAPICallOrPutFlagType	CallOrPutFlag1;                         ///< ǿʾ1
            TAPISTR_10              ContractNo2;                            ///< Լ2
            TAPISTR_10              StrikePrice2;                           ///< ִм2
            TAPICallOrPutFlagType	CallOrPutFlag2;                         ///< ǿʾ2
            TAPIContractTypeType	ContractType;                           ///< Լ
            TAPISTR_10				QuoteUnderlyingContract;				///< ʵԼ
            TAPISTR_70              ContractName;                           ///< Լ
            TAPIDATE                ContractExpDate;                        ///< Լ	
            TAPIDATE                LastTradeDate;                          ///< 
            TAPIDATE                FirstNoticeDate;                        ///< ״֪ͨ
    };


    //! ױϢ
    struct TapAPICurrencyInfo
    {
            TAPISTR_10					CurrencyNo;						///< ֱ
            TAPISTR_10					CurrencyGroupNo;				///< 
            TAPIREAL64					TradeRate;						///< ׻
            TAPIREAL64					TradeRate2;						///< ׻2

            TAPIFutureAlgType			FutureAlg;						///< '1', '2'
            TAPIOptionAlgType			OptionAlg;						///< Ȩ㷨,ڻʽ'1',Ȩʽ'2'
    };
    //=============================================================================
    /**
    *	\addtogroup G_DATATYPE_T_TAPIMSGRECEIVERTYPE	Ϣ
    *	@{
    */
    //=============================================================================
    //! Ϣ
    typedef TAPICHAR				TAPIMsgReceiverType;
    //! ʽ˺ſͻ
    const TAPIMsgReceiverType		TAPI_MSG_RECEIVER_ACCOUNTNO = '1';
    //! ʽ˺ŷ
    const TAPIMsgReceiverType		TAPI_MSG_RECEIVER_ACCOUNTGROUPNO = '2';
    //! Եʽ˺
    const TAPIMsgReceiverType		TAPI_MSG_RECEIVER_ATTRIBUTE = '3';
    //! ָ¼û
    const TAPIMsgReceiverType		TAPI_MSG_RECEIVER_USERNO = '4';
    /** @}*/

    //=============================================================================
    /**
    *	\addtogroup G_DATATYPE_T_TAPIMSGLEVELTYPE	Ϣ
    *	@{
    */
    //=============================================================================
    //! Ϣ
    typedef TAPICHAR				TAPIMsgLevelType;
    //! ͨ
    const TAPIMsgLevelType			TAPI_MSG_LEVEL_NORMAL = '1';
    //! Ҫ
    const TAPIMsgLevelType			TAPI_MSG_LEVEL_IMPORTANT = '2';
    //! 
    const TAPIMsgLevelType			TAPI_MSG_LEVEL_IMERGENCY = '3';
    /** @}*/


    //=============================================================================
    /**
    *	\addtogroup G_DATATYPE_T_TAPIMSGTYPETYPE	Ϣ
    *	@{
    */
    //=============================================================================
    //! Ϣ
    typedef TAPICHAR				TAPIMsgTypeType;
    //! 
    const TAPIMsgTypeType			TAPI_Msg_TYPE_MANAGER = '1';
    //! 
    const TAPIMsgTypeType			TAPI_Msg_TYPE_RISKCONTROL = '2';
    /** @}*/


    //=============================================================================
    /**
    *	\addtogroup G_DATATYPE_T_TAPIBILLTYPETYPE	˵
    *	@{
    */
    //=============================================================================
    //! ˵
    typedef TAPICHAR						TAPIBillTypeType;
    //! ˵
    const TAPIBillTypeType					TAPI_BILL_DATE = 'D';
    //! ˵
    const TAPIBillTypeType					TAPI_BILL_MONTH = 'M';
    /** @}*/

    //=============================================================================
    /**
    *	\addtogroup G_DATATYPE_T_TAPIBILLFILETYPETYPE	ʵļ
    *	@{
    */
    //=============================================================================
    //! ʵļ
    typedef TAPICHAR						TAPIBillFileTypeType;
    //! txtʽļ
    const TAPIBillFileTypeType				TAPI_BILL_FILE_TXT = 'T';
    //! pdfʽļ
    const TAPIBillFileTypeType				TAPI_BILL_FILE_PDF = 'F';
    /** @}*/



    //! ׻Ϣѯṹ
    struct TapAPITradeMessageReq
    {
            TAPISTR_20					AccountNo;
            TAPISTR_20					AccountAttributeNo;
            TAPIDATETIME				BenginSendDateTime;
            TAPIDATETIME				EndSendDateTime;
    };





    //! ϢӦṹ
    struct TapAPITradeMessage
    {
            TAPIUINT32				SerialID;						///< 

            TAPISTR_20				AccountNo;						///< ͻʽ˺

            TAPIDATETIME			TMsgValidDateTime;				///< ϢЧʱ
            TAPISTR_50				TMsgTitle;						///< Ϣ
            TAPISTR_500				TMsgContent;					///< Ϣ
            TAPIMsgTypeType			TMsgType;						///< Ϣ
            TAPIMsgLevelType		TMsgLevel;						///< Ϣ

            TAPIYNFLAG				IsSendBySMS;					///< ǷͶ
            TAPIYNFLAG				IsSendByEMail;					///< Ƿʼ
            TAPISTR_20				Sender;							///<
            TAPIDATETIME			SendDateTime;					///< ʱ
    };

    //! ͻ˵ѯṹ
    struct TapAPIBillQryReq
    {
            TAPISTR_20				UserNo;
            TAPIBillTypeType		BillType;
            TAPIDATE				BillDate;
            TAPIBillFileTypeType	BillFileType;
    };

    //! ͻ˵ѯӦṹ
    struct TapAPIBillQryRsp
    {
            TapAPIBillQryReq		Reqdata;
            TAPIINT32				BillLen;
            TAPICHAR				BillText[1];	///< 䳤˵ݣBillLenָ
    };

    //! ʷίвѯṹ
    struct TapAPIHisOrderQryReq
    {
            TAPISTR_20			AccountNo;							///< ͻʽ˺
            TAPISTR_20			AccountAttributeNo;					///< ͻԺ
            TAPIDATE			BeginDate;							///< ʼʱ ()
            TAPIDATE			EndDate;							///< ʱ ()
    };

    struct TapAPIHisOrderQryRsp
    {
            TAPIDATE					Date;								///< 
            TAPISTR_20					AccountNo;							///< ͻʽ˺

            TAPISTR_10					ExchangeNo;							///< 
            TAPICommodityType			CommodityType;						///< Ʒ
            TAPISTR_10					CommodityNo;						///< Ʒֱ
            TAPISTR_10					ContractNo;							///< Լ
            TAPISTR_10					StrikePrice;						///< ִм۸
            TAPICallOrPutFlagType		CallOrPutFlag;						///< ſ
            TAPISTR_10					ContractNo2;						///< Լ2
            TAPISTR_10					StrikePrice2;						///< ִм۸2
            TAPICallOrPutFlagType		CallOrPutFlag2;						///< ſ2

            TAPIOrderTypeType			OrderType;							///< ί
            TAPIOrderSourceType			OrderSource;						///< ίԴ
            TAPITimeInForceType			TimeInForce;						///< ίЧ
            TAPIDATETIME				ExpireTime;							///< Ч(GTDʹ)
            TAPIYNFLAG					IsRiskOrder;						///< Ƿձ
            TAPISideType				OrderSide;							///< 
            TAPIPositionEffectType		PositionEffect;						///< ƽ־
            TAPIPositionEffectType		PositionEffect2;					///< ƽ־2
            TAPISTR_50					InquiryNo;							///< ѯۺ
            TAPIHedgeFlagType			HedgeFlag;							///< Ͷֵ
            TAPIREAL64					OrderPrice;							///< ίм۸
            TAPIREAL64					OrderPrice2;						///< ίм۸2Ӧʹ
            TAPIREAL64					StopPrice;							///< ۸
            TAPIUINT32					OrderQty;							///< ί
            TAPIUINT32					OrderMinQty;						///< Сɽ
            TAPIUINT32					OrderCanceledQty;					///< 

            TAPIINT32					RefInt;								///< Ͳοֵ
            TAPIREAL64					RefDouble;							///<ο͡
            TAPISTR_50					RefString;							///< ַοֵ

            TAPICHAR					ServerFlag;							///< ʶ
            TAPISTR_20					OrderNo;                                            ///< ίб
            TAPIUINT32					OrderStreamID;						///< ίˮ

            TAPISTR_10					UpperNo;							///< ֺ
            TAPISTR_10					UpperChannelNo;						///< ͨ
            TAPISTR_20					OrderLocalNo;						///< غ
            TAPIUINT32					UpperStreamID;						///< 

            TAPISTR_50					OrderSystemNo;						///< ϵͳ
            TAPISTR_50					OrderExchangeSystemNo;				///< ϵͳ
            TAPISTR_50					OrderParentSystemNo;				///< ϵͳ 

            TAPISTR_20					OrderInsertUserNo;					///< µ
            TAPIDATETIME				OrderInsertTime;					///< µʱ
            TAPISTR_20					OrderCommandUserNo;					///< ָ´
            TAPISTR_20					OrderUpdateUserNo;					///< ίи
            TAPIDATETIME				OrderUpdateTime;					///< ίиʱ

            TAPIOrderStateType			OrderState;							///< ί״̬

            TAPIREAL64					OrderMatchPrice;					///< ɽ
            TAPIREAL64					OrderMatchPrice2;					///< ɽ2
            TAPIUINT32					OrderMatchQty;						///< ɽ
            TAPIUINT32					OrderMatchQty2;						///< ɽ2

            TAPIUINT32					ErrorCode;							///< һβϢ
            TAPISTR_50					ErrorText;							///< Ϣ

            TAPIYNFLAG					IsBackInput;						///< ǷΪ¼ίе
            TAPIYNFLAG					IsDeleted;							///< ίгɽɾ
            TAPIYNFLAG					IsAddOne;							///< ǷΪT+1
            TAPIYNFLAG					AddOneIsValid;						///< ǷT+1Ч

            TAPIUINT32					MinClipSize;						///< ɽС
            TAPIUINT32					MaxClipSize;						///< ɽ
            TAPISTR_50					LicenseNo;							///< Ȩ

            TAPITacticsTypeType			TacticsType;						///< Ե	
            TAPITriggerConditionType	TriggerCondition;					///< 
            TAPITriggerPriceTypeType	TriggerPriceType;					///< ۸

    };
	  //! ʷɽѯṹ
    struct TapAPIHisMatchQryReq
    {
            TAPISTR_20				AccountNo;							///< ͻʽ˺
            TAPISTR_20				AccountAttributeNo;					///< ͻԺ
            TAPIDATE				BeginDate;							///< ʼڣ
            TAPIDATE				EndDate;							///< ڣ
            TAPICHAR				CountType;							///< ͳ
    };

    //! ʷɽѯӦṹ
    //! key1=SerialID
    //! key2=ExchangeNo+MatchCmbNo+MatchNo+MatchSide
    struct TapAPIHisMatchQryRsp
    {

            TAPIDATE				SettleDate;							///< 
            TAPIDATE				TradeDate;							///<
            TAPISTR_20				AccountNo;							///< ͻʽ˺

            TAPISTR_10				ExchangeNo;							///< г߽
            TAPICommodityType		CommodityType;						///< Ʒ
            TAPISTR_10				CommodityNo;						///< Ʒֺ
            TAPISTR_10				ContractNo;							///< Լ
            TAPISTR_10				StrikePrice;						///< ִм
            TAPICallOrPutFlagType	CallOrPutFlag;						///< ǿ־

            TAPIMatchSourceType		MatchSource;						///< ɽԴ	
            TAPISideType			MatchSide;							///< 
            TAPIPositionEffectType	PositionEffect;						///< ƽ־
            TAPIHedgeFlagType		HedgeFlag;							///< Ͷֵ
            TAPIREAL64				MatchPrice;							///< ɽ
            TAPIUINT32				MatchQty;							///< ɽ

            TAPISTR_20				OrderNo;							///< ίк
            TAPISTR_20				MatchNo;							///< ɽ
            TAPIUINT32				MatchStreamID;						///< ɽˮ

            TAPISTR_10				UpperNo;							///< ֺ
            TAPISTR_20				MatchCmbNo;							///< Ϻ
            TAPISTR_70				ExchangeMatchNo;					///< ɽ(ɽ)
            TAPIUINT32				MatchUpperStreamID;					///< ˮ

            TAPISTR_10				CommodityCurrencyGroup;
            TAPISTR_10				CommodityCurrency;					//Ʒֱ		

            TAPIREAL64				Turnover;							///< ɽ
            TAPIREAL64				PremiumIncome;						///< Ȩ
            TAPIREAL64				PremiumPay;							///< Ȩ֧

            TAPIREAL64				AccountFee;							///< ͻ
            TAPISTR_10				AccountFeeCurrencyGroup;
            TAPISTR_10				AccountFeeCurrency;					///< ͻѱ
            TAPIYNFLAG				IsManualFee;						///< ˹ͻѱ
            TAPIREAL64				AccountOtherFee;					//ͻ

            TAPIREAL64				UpperFee;							///< 
            TAPISTR_10				UpperFeeCurrencyGroup;
            TAPISTR_10				UpperFeeCurrency;					///< ѱ
            TAPIYNFLAG				IsUpperManualFee;					///< ˹ѱ
            TAPIREAL64				UpperOtherFee;						//

            TAPIDATETIME			MatchDateTime;						///< ɽʱ
            TAPIDATETIME			UpperMatchDateTime;					///< ֳɽʱ

            TAPIREAL64				CloseProfit;						///< ƽӯ
            TAPIREAL64				ClosePrice;							///< ָƽּ۸

            TAPIUINT32				CloseQty;							///< ƽ

            TAPISTR_10				SettleGroupNo;						///<
            TAPISTR_20				OperatorNo;							///< Ա
            TAPIDATETIME			OperateTime;						///< ʱ


    };

    //! ʷί̲ѯṹ
    struct TapAPIHisOrderProcessQryReq
    {
            TAPIDATE				Date;
            TAPISTR_20				OrderNo;
    };

    //! ʷί̲ѯӦݽṹ
    typedef TapAPIHisOrderQryRsp		TapAPIHisOrderProcessQryRsp;

 
    //=============================================================================
    /**
    *	\addtogroup G_DATATYPE_SETTLEFLAG	
    *	@{
    */
    //=============================================================================
    //! 
    typedef TAPICHAR						TAPISettleFlagType;
    //! Զ
    const TAPISettleFlagType					SettleFlag_AutoSettle = '0';
    //! ˹
    const TAPISettleFlagType					SettleFlagh_Manual= '2';
    /** @}*/   
    
    //! ʷֲֲѯṹ
    struct TapAPIHisPositionQryReq
    {
            TAPISTR_20				AccountNo;						///< ͻʽ˺
            //TAPISTR_20				AccountAttributeNo;				///< ͻԺ
            TAPIDATE				Date;							///< 
            //TAPICHAR				CountType;						///< ͳ
            TAPISettleFlagType                  SettleFlag;                                             ///<
    };

    //! ʷֲֲѯӦṹ
    //! key1=SerialID
    //! key2=++ű+ֱֲ+
    struct TapAPIHisPositionQryRsp
    {
            TAPIDATE				SettleDate;							///< 
            TAPIDATE				OpenDate;							///< 

            TAPISTR_20				AccountNo;							///< ͻʽ˺

            TAPISTR_10				ExchangeNo;							///< г߽
            TAPICommodityType		CommodityType;						///< Ʒ
            TAPISTR_10				CommodityNo;						///< Ʒֱ
            TAPISTR_10				ContractNo;							///< Լ
            TAPISTR_10				StrikePrice;						///< ִм
            TAPICallOrPutFlagType	CallOrPutFlag;						///< ǿ־

            TAPISideType			MatchSide;							///< 
            TAPIHedgeFlagType		HedgeFlag;							///< Ͷֵ
            TAPIREAL64				PositionPrice;						///< ֲּ۸
            TAPIUINT32				PositionQty;						///< ֲ

            TAPISTR_20				OrderNo;							///< 
            TAPISTR_70				PositionNo;							///< ֱֲ

            TAPISTR_10				UpperNo;							///< ֺ	

            TAPISTR_10				CurrencyGroup;						///< Ʒֱ
            TAPISTR_10				Currency;							///< Ʒֱ

            TAPIREAL64				PreSettlePrice;						///< ս۸
            TAPIREAL64				SettlePrice;						///< ۸
            TAPIREAL64				PositionDProfit;					///< ֲӯ()
            TAPIREAL64				LMEPositionProfit;					///< LMEֲӯ
            TAPIREAL64				OptionMarketValue;					///< Ȩֵ

            TAPIREAL64				AccountInitialMargin;				///< ͻʼ֤
            TAPIREAL64				AccountMaintenanceMargin;			///< ͻάֱ֤
            TAPIREAL64				UpperInitialMargin;					///< ֳʼ֤
            TAPIREAL64				UpperMaintenanceMargin;				///< άֱ֤

            TAPISTR_10				SettleGroupNo;						///< 
    };

    //! ѯṹ
    struct TapAPIHisDeliveryQryReq
    {
            TAPISTR_20				AccountNo;							///< ͻʽ˺
            TAPISTR_20				AccountAttributeNo;					///< ͻԺ
            TAPIDATE				BeginDate;							///< ʼڣ
            TAPIDATE				EndDate;							///< ڣ
            TAPICHAR				CountType;							///< ͳ
    };

    //! ѯӦݽṹ
    //! key1=SerialID
    struct TapAPIHisDeliveryQryRsp
    {
            TAPIDATE				DeliveryDate;						///< 
            TAPIDATE				OpenDate;							///< 
            TAPISTR_20				AccountNo;							///< ͻʽ˺

            TAPISTR_10				ExchangeNo;							///< гŻ
            TAPICommodityType       CommodityType;						///< Ʒ
            TAPISTR_10				CommodityNo;						///< Ʒֱ
            TAPISTR_10				ContractNo;							///< Լ
            TAPISTR_10				StrikePrice;						///< ִм
            TAPICallOrPutFlagType	CallOrPutFlag;						///< ǿ־

            TAPIMatchSourceType		MatchSource;						///< ɽԴ
            TAPISideType			OpenSide;							///< ַ
            TAPIREAL64				OpenPrice;							///< ּ۸
            TAPIREAL64				DeliveryPrice;						///< ۸
            TAPIUINT32				DeliveryQty;						///< 
            TAPIUINT32				FrozenQty;							///< 

            TAPISTR_20				OpenNo;								///< ֳɽ
            TAPISTR_10				UpperNo;							///< ֱ

            TAPISTR_10				CommodityCurrencyGroupy;			///< Ʒֱ
            TAPISTR_10				CommodityCurrency;					///< Ʒֱ
            TAPIREAL64				PreSettlePrice;						///< ս
            TAPIREAL64				DeliveryProfit;						///< ӯ

            TAPIREAL64				AccountFrozenInitialMargin;			///< ͻʼᱣ֤
            TAPIREAL64				AccountFrozenMaintenanceMargin;		///< ͻάֶᱣ֤
            TAPIREAL64				UpperFrozenInitialMargin;			///< ֳʼᱣ֤
            TAPIREAL64				UpperFrozenMaintenanceMargin;		///< άֶᱣ֤

            TAPISTR_10				AccountFeeCurrencyGroup;
            TAPISTR_10				AccountFeeCurrency;					///< ͻѱ
            TAPIREAL64				AccountDeliveryFee;					///< ͻ 
            TAPISTR_10				UpperFeeCurrencyGroup;
            TAPISTR_10				UpperFeeCurrency;					///< ѱ
            TAPIREAL64				UpperDeliveryFee;					///< ֽ

            TAPIDeliveryModeType	DeliveryMode;						///< Ȩʽ
            TAPISTR_20				OperatorNo;							///< Ա
            TAPIDATETIME			OperateTime;						///< ʱ
            TAPISTR_20				SettleGourpNo;						///< 
    };

    //! ͻʽѯṹ
    struct TapAPIAccountCashAdjustQryReq
    {
            TAPIUINT32				SerialID;
            TAPISTR_20				AccountNo;
            TAPISTR_20				AccountAttributeNo;				///< ͻ
            TAPIDATE				BeginDate;						///< 
            TAPIDATE				EndDate;						///< 
    };

    //! ͻʽѯӦṹ
    struct TapAPIAccountCashAdjustQryRsp
    {
            TAPIDATE					Date;							///< 
            TAPISTR_20					AccountNo;						///< ͻʽ˺

            TAPICashAdjustTypeType		CashAdjustType;					///< ʽ
            TAPISTR_10					CurrencyGroupNo;					//
            TAPISTR_10					CurrencyNo;						///< ֺ
            TAPIREAL64					CashAdjustValue;				///< ʽ
            TAPISTR_100					CashAdjustRemark;				///< ʽע

            TAPIDATETIME				OperateTime;					///< ʱ
            TAPISTR_20					OperatorNo;						///< Ա

            TAPISTR_10					AccountBank;					///< ͻ
            TAPISTR_20					BankAccount;					///< ͻ˺
            TAPIBankAccountLWFlagType	AccountLWFlag;					///< ͻұʶ
            TAPISTR_10					CompanyBank;					///< ˾
            TAPISTR_20					InternalBankAccount;			///< ˾˻
            TAPIBankAccountLWFlagType	CompanyLWFlag;					///< ˾ұʶ
    };
	//! ͻ˻Ѽѯṹ
	struct TapAPIAccountFeeRentQryReq
	{
		TAPISTR_20						AccountNo;
	};
	//! ͻ˻ѼѯӦṹ
	struct TapAPIAccountFeeRentQryRsp
	{
		TAPISTR_20						AccountNo;
		TAPISTR_10						ExchangeNo;
		TAPICommodityType				CommodityType;
		TAPISTR_10						CommodityNo;
		TAPIMatchSourceType				MatchSource;
		TAPICalculateModeType			CalculateMode;
		TAPISTR_10						CurrencyGroupNo;				
		TAPISTR_10						CurrencyNo;						
		TAPIREAL64						OpenCloseFee;
		TAPIREAL64						CloseTodayFee;
	};
	//! ͻ˻֤ѯṹ
	struct TapAPIAccountMarginRentQryReq
	{
		TAPISTR_20						AccountNo;
		TAPISTR_10						ExchangeNo;
		TAPICommodityType				CommodityType;
		TAPISTR_10						CommodityNo;
		//TAPISTR_10						ContractNo;//ʱȲ⿪š
	};

	//! ͻ˻֤ѯӦ
	struct  TapAPIAccountMarginRentQryRsp
	{
		TAPISTR_20						AccountNo;
		TAPISTR_10						ExchangeNo;
		TAPICommodityType				CommodityType;
		TAPISTR_10						CommodityNo;
		TAPISTR_10						ContractNo;
		TAPISTR_10						StrikePrice;
		TAPICallOrPutFlagType			CallOrPutFlag;
		TAPICalculateModeType			CalculateMode;
		TAPISTR_10						CurrencyGroupNo;
		TAPISTR_10						CurrencyNo;
		TAPIREAL64						InitialMargin;
		TAPIREAL64						MaintenanceMargin;
		TAPIREAL64						SellInitialMargin;
		TAPIREAL64						SellMaintenanceMargin;
		TAPIREAL64						LockMargin;
	};
	//! ۽ѯ֪ͨ
	struct TapAPIOrderQuoteMarketNotice
	{
		TAPISTR_10						ExchangeNo;				///< 
		TAPICommodityType				CommodityType;			///< Ʒ
		TAPISTR_10						CommodityNo;			///< Ʒֱ
		TAPISTR_10						ContractNo;				///< Լ
		TAPISTR_10						StrikePrice;			///< ִм
		TAPICallOrPutFlagType			CallOrPutFlag;			///< ǿ
		TAPISideType					OrderSide;				///< 
		TAPIUINT32						OrderQty;				///< ί
	};

	//! µṹ
	struct TapAPIOrderMarketInsertReq
	{
		TAPISTR_20				AccountNo;					///< ͻʽʺ
		TAPISTR_10				ExchangeNo;					///< 
		TAPICommodityType		CommodityType;				///< Ʒ
		TAPISTR_10				CommodityNo;				///< Ʒֱ
		TAPISTR_10				ContractNo;					///< Լ
		TAPISTR_10				StrikePrice;					///< ִм۸
		TAPICallOrPutFlagType		CallOrPutFlag;				///< ſ
		TAPIOrderTypeType		OrderType;					///< ί
		TAPITimeInForceType		TimeInForce;					///< Ч
		TAPIDATETIME			ExpireTime;						///< Ч
		TAPIOrderSourceType		OrderSource;					///< ίԴ	
		TAPIPositionEffectType	BuyPositionEffect;				///< ƽ־
		TAPIPositionEffectType	SellPositionEffect;				///< ƽ־

		TAPIYNFLAG				AddOneIsValid;					///< ǷT+1Ч
		TAPIREAL64				OrderBuyPrice;				///< ίм
		TAPIREAL64				OrderSellPrice;				///< ίм	
		TAPIUINT32				OrderBuyQty;					///< ί
		TAPIUINT32				OrderSellQty;					///< ί
		TAPISTR_50				ClientBuyOrderNo;			///< ίб
		TAPISTR_50				ClientSellOrderNo;				///< ίб
		TAPIINT32				RefInt;						///< Ͳοֵ
		TAPIREAL64				RefDouble;					///< οֵ
		TAPISTR_50				RefString;					///< ַοֵ
		TAPISTR_100				Remark;						///< ע
	};

	//! ͻӦṹ
	struct TapAPIOrderMarketInsertRsp
	{
		TAPISTR_20							AccountNo;						///< ͻʽʺ

		TAPISTR_10							ExchangeNo;						///< 
		TAPICommodityType					CommodityType;					///< Ʒ
		TAPISTR_10							CommodityNo;					///< Ʒֱ
		TAPISTR_10							ContractNo;						///< Լ
		TAPISTR_10							StrikePrice;					///< ִм۸
		TAPICallOrPutFlagType				CallOrPutFlag;					///< ſ

		TAPIOrderTypeType					OrderType;						///< ί
		TAPITimeInForceType					TimeInForce;					///< ίЧ
		TAPIDATETIME						ExpireTime;						///< Ч(GTDʹ)
		TAPIOrderSourceType					OrderSource;					///< ίԴ

		TAPIPositionEffectType				BuyPositionEffect;				///< ƽ־
		TAPIPositionEffectType				SellPositionEffect;				///< ƽ־

		TAPIREAL64							OrderBuyPrice;					///< ίм
		TAPIREAL64							OrderSellPrice;					///< ίм

		TAPIUINT32							OrderBuyQty;					///< ί
		TAPIUINT32							OrderSellQty;					///< ί

		TAPICHAR							ServerFlag;						///< ׷ʶ
		TAPISTR_20							OrderBuyNo;						///< ίк
		TAPISTR_20							OrderSellNo;					///< ίк

		TAPIYNFLAG							AddOneIsValid;					///< ǷT+1Ч

		TAPISTR_20							OrderMarketUserNo;				///< µ
		TAPIDATETIME						OrderMarketTime;				///< µʱ

		TAPIINT32							RefInt;							///< Ͳοֵ
		TAPIREAL64							RefDouble;						///< οֵ
		TAPISTR_50							RefString;						///< ַοֵ

		TAPISTR_50							ClientBuyOrderNo;				///< 򱾵ίб
		TAPISTR_50							ClientSellOrderNo;				///< ίб

		TAPIUINT32							ErrorCode;						///< Ϣ
		TAPISTR_50							ErrorText;						///< Ϣ
			
		TAPISTR_40							ClientLocalIP;					///< ն˱IPַͻд
		TAPIMACTYPE							ClientMac;						///< ն˱Macַͻд

		TAPISTR_40							ClientIP;						///< ǰü¼նIPַǰд

		TAPISTR_100							Remark;							///< ע
	};
	//! ۽˫߳
	struct TapAPIOrderMarketDeleteReq
	{
		TAPICHAR				ServerFlag;
		TAPISTR_20				OrderBuyNo;					///< ίк
		TAPISTR_20				OrderSellNo;					///< ίк
	};
	typedef TapAPIOrderMarketInsertRsp TapAPIOrderMarketDeleteRsp;


	//! ɾṹ

	struct TapAPIOrderLocalRemoveReq
	{
		TAPICHAR				ServerFlag;
		TAPISTR_20				OrderNo;					
	};

	//! ɾӦṹ
	struct TapAPIOrderLocalRemoveRsp
	{
		TapAPIOrderLocalRemoveReq req;
		TAPISTR_40							ClientLocalIP;					//ն˱IPַͻд
		TAPIMACTYPE							ClientMac;						//ն˱Macַͻд

		TAPISTR_40							ClientIP;						//ǰü¼նIPַǰд
	};

	//! ¼ṹ
	struct TapAPIOrderLocalInputReq
	{
		TAPISTR_20					AccountNo;						///< ͻʽʺ

		TAPISTR_10					ExchangeNo;						///< 
		TAPICommodityType			CommodityType;					///< Ʒ
		TAPISTR_10					CommodityNo;					///< Ʒֱ
		TAPISTR_10					ContractNo;						///< Լ1
		TAPISTR_10					StrikePrice;					///< ִм۸1
		TAPICallOrPutFlagType		CallOrPutFlag;					///< ſ1
		TAPISTR_10					ContractNo2;					///< Լ2
		TAPISTR_10					StrikePrice2;					///< ִм۸2
		TAPICallOrPutFlagType		CallOrPutFlag2;					///< ſ2

		TAPIOrderTypeType			OrderType;						///< ί
		TAPIOrderSourceType			OrderSource;					///< ίԴ
		TAPITimeInForceType			TimeInForce;					///< ίЧ
		TAPIDATETIME				ExpireTime;						///< Ч(GTDʹ)

		TAPIYNFLAG					IsRiskOrder;					///< Ƿձ
		TAPISideType				OrderSide;						///< 
		TAPIPositionEffectType		PositionEffect;					///< ƽ־1
		TAPIPositionEffectType		PositionEffect2;				///< ƽ־2
		TAPISTR_50					InquiryNo;						///< ѯۺ
		TAPIHedgeFlagType			HedgeFlag;						///< Ͷֵ
		TAPIREAL64					OrderPrice;						///< ίм۸1
		TAPIREAL64					OrderPrice2;					///< ίм۸2Ӧʹ
		TAPIREAL64					StopPrice;						///< ۸
		TAPIUINT32					OrderQty;						///< ί
		TAPIUINT32					OrderMinQty;					///< Сɽ
		TAPISTR_50					OrderSystemNo;					///< ϵͳ
		TAPISTR_50					OrderExchangeSystemNo;			///< ϵͳ

		TAPISTR_10					UpperNo;						///< ֺ
		TAPIREAL64					OrderMatchPrice;				///< ɽ1
		TAPIREAL64					OrderMatchPrice2;				///< ɽ2
		TAPIUINT32					OrderMatchQty;					///< ɽ1
		TAPIUINT32					OrderMatchQty2;					///< ɽ2

		TAPIOrderStateType			OrderState;						///< ί״̬

		TAPIYNFLAG					IsAddOne;						///< ǷΪT+1
	};
	typedef TapAPIOrderInfo TapAPIOrderLocalInputRsp;

	struct TapAPIOrderLocalModifyReq
	{
		TapAPIOrderLocalInputReq	req;
		TAPICHAR					ServerFlag;						///< ʶ
		TAPISTR_20					OrderNo;						///< ίб
	};

	typedef TapAPIOrderInfo TapAPIOrderLocalModifyRsp;

	struct TapAPIOrderLocalTransferReq
	{
		TAPISTR_20					AccountNo;						///< ͻʽʺ
		TAPICHAR					ServerFlag;						///< ʶ
		TAPISTR_20					OrderNo;						///< ίб
	};

	typedef TapAPIOrderInfo TapAPIOrderLocalTransferRsp;


	struct TapAPIFillLocalInputReq
	{
		TAPISTR_20					AccountNo;						///< ͻʽʺ

		TAPISTR_10					ExchangeNo;						///< 
		TAPICommodityType			CommodityType;					///< Ʒ
		TAPISTR_10					CommodityNo;					///< Ʒֱ
		TAPISTR_10					ContractNo;						///< Լ1
		TAPISTR_10					StrikePrice;					///< ִм۸
		TAPICallOrPutFlagType		CallOrPutFlag;					///< ſ

	
		TAPISideType				MatchSide;						///< 
		TAPIPositionEffectType      PositionEffect;					///< ƽ־1
		TAPIHedgeFlagType			HedgeFlag;						///< Ͷֵ
		TAPIREAL64					MatchPrice;						///< ɽ
		TAPIUINT32					MatchQty;						///< ɽ

		TAPISTR_50					OrderSystemNo;					///< ϵͳ


		
		TAPISTR_70					UpperMatchNo;					///< ֳɽ
		TAPIDATETIME				MatchDateTime;					///< ɽʱ
		TAPIDATETIME				UpperMatchDateTime;				///< ֳɽʱ
		TAPISTR_10					UpperNo;						///< ֺ

		TAPIYNFLAG					IsAddOne;						///< ǷΪT+1

		TAPISTR_10					FeeCurrencyGroup;				///< ͻѱ
		TAPISTR_10					FeeCurrency;					///< ͻѱ
		TAPIREAL64					FeeValue;						///< 
		TAPIYNFLAG					IsManualFee;					///< ˹ͻѱ

		TAPIREAL64					ClosePositionPrice;					///< ָ۸ƽ
	};
	typedef  TapAPIFillLocalInputReq TapAPIFillLocalInputRsp;


	//! ͻ¼ɽɾṹ
	struct	TapAPIFillLocalRemoveReq
	{
		TAPICHAR					ServerFlag;						///< ʶ
		TAPISTR_20					MatchNo;						///< سɽ
	};
	//! ͻ¼ɽɾӦṹ
	typedef TapAPIFillLocalRemoveReq	TapAPIFillLocalRemoveRsp;

	//! ϵͳղѯӦ
	struct TapAPITradingCalendarQryRsp
	{
		TAPIDATE CurrTradeDate;										///< ǰ
		TAPIDATE LastSettlementDate;								///< ϴν
		TAPIDATE PromptDate;										///< LME
		TAPIDATE LastPromptDate;									///< LME
	};

	//! ͻֻѯṹ
	struct TapAPISpotLockQryReq
	{
		TAPISTR_20					AccountNo;						///<ͻʽʺ
	};
	//! ͻֻѯӦṹ
	typedef TapAPISpotLockQryReq				TapAPISpotLockQryRsp;
	//! ͻֻѯӦṹ
	struct TapAPISpotLockDataRsp
	{
		TAPISTR_20					AccountNo;						///<ͻʽ˺

		TAPISTR_10					ExchangeNo;						///< 
		TAPICommodityType			CommodityType;					///< Ʒ
		TAPISTR_10					CommodityNo;					///< Ʒֱ

		TAPIUINT32					LockQty;						///<
		TAPIUINT32					FrozenQty;						///<
		TAPIUINT32					CanUnLockQty;					///<ɽ
	};
	//! ͻֻ֪ͨ
	typedef TapAPISpotLockDataRsp				TapAPISpotLockDataNotice;




#pragma pack(pop)
}
#endif //TAP_TRADE_API_DATA_TYPE_H