#ifndef ITAP_TRADE_API_H
#define ITAP_TRADE_API_H

#include "iTapTradeAPIDataType.h"
//#include "TapProtocol.h"

#if defined WIN32 || defined WIN64
#define TAP_CDECL __cdecl
#define TAP_DLLEXPORT __declspec(dllexport)
#else
#define TAP_CDECL
#define TAP_DLLEXPORT
#endif
//TapTradeAPI.h
//ļTapTradeAPIṩߵĶӿڡͻصӿڡ

//TapTradeAPI Ļص֪ͨӿڡ
namespace ITapTrade
{
	/**
	 * @brief ص:ITapTradeAPINotify
	 * @details TapTradeAPIĻص֪ͨӿڡ
	 */
	class ITapTradeAPINotify
	{
	public:
		/**
		* @brief ӳɹص֪ͨ
		* @details	󣬿öַOnConnectֻ֪ͨӳɹĵַ
		* @param[in] HostAddress ʽΪIP:PORT0.0.0.0:1234
		* @attention	ûصسɹ˵ַӳɹ¼ɹ
		* @ingroup G_T_Login
		*/
		virtual void TAP_CDECL OnConnect(const ITapTrade::TAPISTR_40 HostAddress) = 0;
		/**
		* @brief	ϵͳ¼̻ص
		* @details	˺ΪLogin()¼ĻصLogin()ɹ·ӣȻAPI͵¼֤Ϣ
		*			¼ڼݷ͵¼ĻϢݵ˻صС¼Ϣ´ζ֤ڡ
		* @param[in] errorCode ش,0ʾɹ
		* @param[in] loginRspInfo ¼ӦϢerrorCode!=0loginRspInfo=NULL
		* @attention	ûصسɹ˵û¼ɹǲAPI׼ϡ
		* @ingroup G_T_Login
		*/
		virtual void TAP_CDECL OnRspLogin(ITapTrade::TAPIINT32 errorCode, const ITapTrade::TapAPITradeLoginRspInfo *loginRspInfo) = 0;
		/**
		* @brief	֤ϵʽ֪ͨ
		* @details	¼ɺҪ֤9.2.7̨յϵʽ֪ͨѡ֪ͨϢһϵʽߵ绰
		*			Ͷ֤Ȩ루RequestVertificateCode
		* @param[in] errorCode ش,0ʾɹ˻ûа󶨶֤ϵʽ򷵻10016
		* @param[in] isLast,ʶǷһϵϢ
		* @param[in] ֤ʽϢerrorCode!=0ContactInfoΪա
		* @attention ûصسɹ˵Ҫ֤ҪѡһϵʽȻRequestVertificateCode
		* @ingroup G_T_Login
		*/
		virtual void TAP_CDECL OnRtnContactInfo(ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TAPISTR_40 ContactInfo) = 0;

		/**
		* @brief	Ͷ֤Ӧ
		* @details	ȡ֤Ȩ룬̨ʼ߶ţӦ𣬰Լ֤Чڡ
		*
		* @param[in] sessionID ֤ỰID
		* @param[in]  errorCode ûаϵ10016.
		* @param[in]  rsp֤Чڣ뷵أڶ֤Чڣظö֤룬ǲ֤롣
		* @attention	ûصسɹ˵֤ѷĿֻ䣬ҪSetVertificateCodeֻյ֤뷢͸̨
		* @ingroup G_T_Login
		*/
		virtual void TAP_CDECL OnRspRequestVertificateCode(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, const TapAPIRequestVertificateCodeRsp *rsp) = 0;

		/**
		* @brief	APIѻص
		* @details	˺ΪLogin()¼ɹ뵱ǰС30죬лصѡ
		* @param[in] date APIȨա
		* @param[in] days ػмȨڡ
		* @attention	úص˵Ȩһ֮ڵڡ򲻲ûص
		* @ingroup G_T_Login
		*/
		virtual void TAP_CDECL OnExpriationDate(ITapTrade::TAPIDATE date, int days) = 0;

		/**
		* @brief	֪ͨûAPI׼
		* @details	ֻûصյ˾֪ͨʱܽкĸݲѯ\n
		*			˻صAPIܷı־
		* @attention ſԽк
		* @ingroup G_T_Login
		*/
		virtual void TAP_CDECL OnAPIReady(ITapTrade::TAPIINT32 errorCode) = 0;
		/**
		* @brief	APIͷʧȥӵĻص
		* @details	APIʹù߱ʧȥӺ󶼻ᴥ˻ص֪ͨûѾϿ
		* @param[in] reasonCode Ͽԭ롣
		* @attention ע⣬OnDisconnect̨ӶϿʱŻص˺֮ǰѶϿDisconnectʱص˺
		* @ingroup G_T_Disconnect
		*/
		virtual void TAP_CDECL OnDisconnect(ITapTrade::TAPIINT32 reasonCode) = 0;
		/**
		* @brief ֪ͨû޸Ľ
		* @param[in] sessionID ޸ĻỰID,ChangePasswordصĻỰIDӦ
		* @param[in] errorCode ش룬0ʾɹ
		* @ingroup G_T_UserInfo
		*/
		virtual void TAP_CDECL OnRspChangePassword(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode) = 0;

		/**
		* @brief ֤˻뷴
		* @param[in] sessionID ޸ĻỰID,AuthPasswordصĻỰIDӦ
		* @param[in] errorCode ش룬0ʾɹ
		* @ingroup G_T_UserInfo
		*/
		virtual void TAP_CDECL OnRspAuthPassword(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode) = 0;
		/**
		* @brief	ϵͳں͵LME
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] info ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_TradeSystem
		*/

		virtual void TAP_CDECL OnRspQryTradingDate(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, const ITapTrade::TapAPITradingCalendarQryRsp *info) = 0;
		/**
		* @brief ûԤϢ
		* @param[in] sessionID ûԤϢĻỰID
		* @param[in] errorCode ش룬0ʾɹ
		* @param[in] info ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @note ýӿδʵ
		* @ingroup G_T_UserInfo
		*/
		virtual void TAP_CDECL OnRspSetReservedInfo(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, const ITapTrade::TAPISTR_50 info) = 0;
		/**
		* @brief	ûϢ
		* @details	˻صӿûزѯʽ˺ŵϸϢûбҪõ˺űűȻںĺʹá
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] isLast ʾǷһݣ
		* @param[in] info ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_AccountInfo
		*/
		virtual void TAP_CDECL OnRspQryAccount(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIUINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPIAccountInfo *info) = 0;
		/**
		* @brief ʽ˻ʽϢ
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] isLast 	ʾǷһݣ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_AccountDetails
		*/
		virtual void TAP_CDECL OnRspQryFund(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPIFundData *info) = 0;
		/**
		* @brief	ûʽ仯֪ͨ
		* @details	ûίгɽʽݵı仯Ҫûʵʱ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_AccountDetails
		*/
		virtual void TAP_CDECL OnRtnFund(const ITapTrade::TapAPIFundData *info) = 0;
		/**
		* @brief ϵͳеĽϢ
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] isLast 	ʾǷһݣ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_TradeSystem
		*/
		virtual void TAP_CDECL OnRspQryExchange(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPIExchangeInfo *info) = 0;
		/**
		* @brief	ϵͳƷϢ
		* @details	˻صӿûصõƷϢ
		* @param[in] sessionID ĻỰIDGetAllCommodities()ضӦ
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] isLast 	ʾǷһݣ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_Commodity
		*/
		virtual void TAP_CDECL OnRspQryCommodity(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPICommodityInfo *info) = 0;
		/**
		* @brief ϵͳкԼϢ
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] isLast 	ʾǷһݣ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_Contract
		*/
		virtual void TAP_CDECL OnRspQryContract(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPITradeContractInfo *info) = 0;
		/**
		* @brief	ԼϢ
		* @details	ûµĺԼҪڽʱзºԼʱûԼϢ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_Contract
		*/
		virtual void TAP_CDECL OnRtnContract(const ITapTrade::TapAPITradeContractInfo *info) = 0;
		/**
		* @brief	Ӧ
		* @details	µĵӦµдӦصµṹûдԼʽ˺ţشš\n
				 * ĵӦOnRtnOrderɹOnRtnOrderص\n
				 * sessionIDʶӦsessionIDԱȷñӦӦ\n
				 *
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] info ӦͣͺͶϢָ롣
				 * Ϣָ벿¿ΪգΪգͨSessiuonIDҵӦȡ͡
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_TradeActions
		*/
		virtual void TAP_CDECL OnRspOrderAction(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, const ITapTrade::TapAPIOrderActionRsp *info) = 0;
		/**
		* @brief ί֪ͨµĻطµ͹ġ
		* @details	յͻµίݺͻᱣȴͬʱûһ
		*			ίϢ˵ȷû󣬷صϢаȫίϢ
		*			ͬʱһʾίеίкš
		* @param[in] info ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_TradeActions
		*/
		virtual void TAP_CDECL OnRtnOrder(const ITapTrade::TapAPIOrderInfoNotice *info) = 0;
		/**
		* @brief	زѯίϢ
		* @details	ûѯίеľϢ
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] isLast ʾǷһݣ
		* @param[in] info ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_TradeInfo
		*/
		virtual void TAP_CDECL OnRspQryOrder(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPIOrderInfo *info) = 0;
		/**
		* @brief زѯίб仯Ϣ
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 룬errorCode==0ʱinfoָ򷵻صίб仯̽ṹ壬ȻΪNULL
		* @param[in] isLast ʾǷһݣ
		* @param[in] info صίб仯ָ롣
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_TradeInfo
		*/
		virtual void TAP_CDECL OnRspQryOrderProcess(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPIOrderInfo *info) = 0;
		/**
		* @brief زѯĳɽϢ
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] isLast 	ʾǷһݣ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_TradeInfo
		*/
		virtual void TAP_CDECL OnRspQryFill(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPIFillInfo *info) = 0;
		/**
		* @brief	ĳɽϢ֪ͨ
		* @details	ûίгɽûͳɽϢ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_TradeActions
		*/
		virtual void TAP_CDECL OnRtnFill(const ITapTrade::TapAPIFillInfo *info) = 0;
		/**
		* @brief زѯĳֲ
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] isLast 	ʾǷһݣ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_TradeInfo
		*/
		virtual void TAP_CDECL OnRspQryPosition(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPIPositionInfo *info) = 0;
		/**
		* @brief ֱֲ仯֪ͨ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_TradeActions
		*/
		virtual void TAP_CDECL OnRtnPosition(const ITapTrade::TapAPIPositionInfo *info) = 0;
		/**
		* @brief زѯĳֲֻ
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] isLast 	ʾǷһݣ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_TradeInfo
		*/
		virtual void TAP_CDECL OnRspQryPositionSummary(TAPIUINT32 sessionID, TAPIINT32 errorCode, TAPIYNFLAG isLast, const TapAPIPositionSummary *info) = 0;

		/**
		* @brief ֲֻܱ仯֪ͨ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_TradeActions
		*/
		virtual void TAP_CDECL OnRtnPositionSummary(const TapAPIPositionSummary *info) = 0;
		/**
		* @brief ֲӯ֪ͨ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_TradeActions
		*/
		virtual void TAP_CDECL OnRtnPositionProfit(const ITapTrade::TapAPIPositionProfitNotice *info) = 0;


		/**
		* @brief ϵͳеıϢ
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] isLast 	ʾǷһݣ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_TradeSystem
		*/
		virtual void TAP_CDECL OnRspQryCurrency(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPICurrencyInfo *info) = 0;

		/**
		* @brief	Ϣ֪ͨ
		* @details	زѯûʽ״̬ϢϢ˵ûʽ״̬ûҪϸ鿴ЩϢ
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] isLast 	ʾǷһݣ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		˵ʢӿ
		* @ingroup G_T_AccountDetails
		*/
		virtual void TAP_CDECL OnRspQryTradeMessage(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPITradeMessage *info) {};
		/**
		* @brief	ϢѯӦ
		* @details	ûڽ׹пΪʽ𡢳ֲ֡ƽֵ״̬䶯ʹ˻ĳЩΣ״̬ĳЩҪϢҪû֪ͨ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		˵ʢӿ
		* @ingroup G_T_AccountDetails
		*/
		virtual void TAP_CDECL OnRtnTradeMessage(const ITapTrade::TapAPITradeMessage *info) {};
		/**
		* @brief ʷίвѯӦ
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] isLast 	ʾǷһ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_HisInfo
		*/
		virtual void TAP_CDECL OnRspQryHisOrder(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPIHisOrderQryRsp *info) {};
		/**
		* @brief ʷί̲ѯӦ
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] isLast 	ʾǷһ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_HisInfo
		*/
		virtual void TAP_CDECL OnRspQryHisOrderProcess(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPIHisOrderProcessQryRsp *info) {};
		/**
		* @brief ʷɽѯӦ
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] isLast 	ʾǷһ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_HisInfo
		*/
		virtual void TAP_CDECL OnRspQryHisMatch(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPIHisMatchQryRsp *info) {};
		/**
		* @brief ʷֲֲѯӦ
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] isLast 	ʾǷһ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_HisInfo
		*/
		virtual void TAP_CDECL OnRspQryHisPosition(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPIHisPositionQryRsp *info) {};
		/**
		* @brief ʷѯӦ
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] isLast 	ʾǷһ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_HisInfo
		*/
		virtual void TAP_CDECL OnRspQryHisDelivery(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPIHisDeliveryQryRsp *info) {};
		/**
		* @brief ʽѯӦ
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] isLast 	ʾǷһ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_HisInfo
		*/
		virtual void TAP_CDECL OnRspQryAccountCashAdjust(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPIAccountCashAdjustQryRsp *info) {};
		/**
		* @brief ѯû˵Ӧ Add:2013.12.11
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_Bill
		*/
		virtual void TAP_CDECL OnRspQryBill(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPIBillQryRsp *info) {};
		/**
		* @brief ѯ˻Ѽ Add:2017.01.14
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_Rent
		*/
		virtual void TAP_CDECL OnRspQryAccountFeeRent(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPIAccountFeeRentQryRsp *info) {};
		/**
		* @brief ѯ˻֤ Add:2017.01.14
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_Rent
		*/
		virtual void TAP_CDECL OnRspQryAccountMarginRent(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPIAccountMarginRentQryRsp *info) {};

		/**
		* @brief ۽˫߱Ӧ Add:2017.08.29
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_HKMarket
		*/
		virtual void TAP_CDECL OnRspHKMarketOrderInsert(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, const ITapTrade::TapAPIOrderMarketInsertRsp *info) {};

		/**
		* @brief ۽˫߳Ӧ Add:2017.08.29
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_HKMarket
		*/
		virtual void TAP_CDECL OnRspHKMarketOrderDelete(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, const ITapTrade::TapAPIOrderMarketDeleteRsp *info) {};

		/**
		* @brief ۽ѯ֪ͨ Add:2017.08.29
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_HKMarket
		*/
		virtual void TAP_CDECL OnHKMarketQuoteNotice(const ITapTrade::TapAPIOrderQuoteMarketNotice *info) {};


		/**
		* @brief ɾӦ Add:2017.12.05
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_LocalActions
		*/
		virtual void TAP_CDECL OnRspOrderLocalRemove(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, const ITapTrade::TapAPIOrderLocalRemoveRsp *info) {};

		/**
		* @brief ¼Ӧ Add:2017.12.05
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_LocalActions
		*/
		virtual void TAP_CDECL OnRspOrderLocalInput(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, const ITapTrade::TapAPIOrderLocalInputRsp *info) {};

		/**
		* @brief ޸Ӧ Add:2017.12.05
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_LocalActions
		*/
		virtual void TAP_CDECL OnRspOrderLocalModify(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, const ITapTrade::TapAPIOrderLocalModifyRsp *info) {};

		/**
		* @brief תӦ Add:2017.12.05
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_LocalActions
		*/
		virtual void TAP_CDECL OnRspOrderLocalTransfer(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, const ITapTrade::TapAPIOrderLocalTransferRsp *info) {};

		/**
		* @brief ɽ¼Ӧ Add:2017.12.05
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_LocalActions
		*/
		virtual void TAP_CDECL OnRspFillLocalInput(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, const ITapTrade::TapAPIFillLocalInputRsp *info) {};

		/**
		* @brief ɽɾӦ Add:2017.12.05
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_LocalActions
		*/
		virtual void TAP_CDECL OnRspFillLocalRemove(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, const ITapTrade::TapAPIFillLocalRemoveRsp *info) {};

		/**
		* @brief ͻֻѯӦ
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] isLast 	ʾǷһ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_Spot
		*/
		virtual void TAP_CDECL OnRspQrySpotLock(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPISpotLockDataRsp *info) {};

		/**
		* @brief ͻֻ֪ͨ
		* @param[in] info		ָ򷵻صϢṹ塣
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_Spot
		*/
		virtual void TAP_CDECL OnRtnSpotLock(const ITapTrade::TapAPISpotLockDataRsp *info) {};

		/**
		* @brief ûύû¼ϢӦ
		* @details ֱڵ½յӦ͵¼ӦмύɼյӦ
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] isLast 	ʾǷһ
		* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention  Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_Spot
		*/
		virtual void TAP_CDECL OnRspSubmitUserLoginInfo(TAPIUINT32 sessionID, TAPIINT32 errorCode, TAPIYNFLAG isLast, const TapAPISubmitUserLoginRspInfo * info) {};
		/**
		* @brief	ҵίвӦ
		* @details	ҵдӦصsessionIDʶӦsessionIDԱȷñӦӦ\n
		* @param[in] sessionID ĻỰID
		* @param[in] errorCode 롣0 ʾɹ
		* @param[in] info ӦͣͺͶϢָ롣
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_Spot
		*/
		virtual void TAP_CDECL OnRspSpecialOrderAction(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, const ITapTrade::TapAPISpecialOrderInfo *info) {};
		/**
		* @brief ҵί֪ͨ
		* @details	صϢаȫҵίϢͬʱһʾҵίеίкš
		* @param[in] info ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_Spot
		*/
		virtual void TAP_CDECL OnRtnSpecialOrder(const ITapTrade::TapAPISpecialOrderInfo *info) {};
		/**
		* @brief ҵίϢѯ
		* @details	ѯĲѯ
		* @param[in] info ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_Spot
		*/
		virtual void TAP_CDECL OnRspQrySpecialOrder(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPISpecialOrderInfo *info) {};
		/**
		* @brief ϳֲϢѯ
		* @details	ѯĲѯ
		* @param[in] info ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_Spot
		*/
		virtual void TAP_CDECL OnRspQryCombinePosition(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const  ITapTrade::TapAPICombinePositionInfo *info) {};
		/**
		* @brief  ϳֱֲ仯֪ͨ
		* @param[in] info ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_Spot
		*/
		virtual void TAP_CDECL OnRtnCombinePosition(const ITapTrade::TapAPICombinePositionInfo *info) {};

		/**
		* @brief  زѯû豸
		* @param[in] info ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_TrustDevice
		*/
		virtual  void TAP_CDECL  OnRspQryUserTrustDevice(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const  ITapTrade::TapAPIUserTrustDeviceQryRsp *info) {};

		/**
		* @brief  û豸
		* @param[in] info ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_TrustDevice
		*/
		virtual  void TAP_CDECL  OnRspAddUserTrustDevice(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, const ITapTrade::TapAPIUserTrustDeviceAddRsp *info) {};

		/**
		* @brief  ɾû豸
		* @param[in] info ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_TrustDevice
		*/
		virtual  void TAP_CDECL  OnRspDelUserTrustDevice(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, const ITapTrade::TapAPIUserTrustDeviceDelRsp *info) {};

		/**
		* @brief  û豸֪ͨ
		* @param[in] info ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_TrustDevice
		*/
		virtual  void TAP_CDECL  OnRtnAddUserTrustDevice(const ITapTrade::TapAPIUserTrustDeviceAddRsp *info) {};

		/**
		* @brief  û豸ɾ֪ͨ
		* @param[in] info ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_TrustDevice
		*/
		virtual  void TAP_CDECL  OnRtnDelUserTrustDevice(const ITapTrade::TapAPIUserTrustDeviceDelRsp *info) {};

		/**
		* @brief  IPOϢѯ
		* @param[in] info ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_IPO
		*/
		virtual  void TAP_CDECL  OnRspQryIPOInfo(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPIIPOInfoQryRsp *info) {};
		/**
		* @brief  IPO깺ѯ
		* @details ÿһƷַض깺
		* @param[in] info ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_IPO
		*/
		virtual  void TAP_CDECL  OnRspQryIPOStockQty(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPIAvailableApplyQryRsp *info) {};
		/**
		* @brief  ûIPOϢѯӦ
		* @param[in] info ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_IPO
		*/
		virtual  void TAP_CDECL  OnRspQryAccountIPO(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, ITapTrade::TAPIYNFLAG isLast, const ITapTrade::TapAPIAccountIPOQryRsp *info) {};
		/**
		* @brief  ûIPOϢӦ
		* @param[in] info ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_IPO
		*/
		virtual  void TAP_CDECL  OnRspAddAccountIPO(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, const ITapTrade::TapAPIAccountIPOAddRsp *info) {};
		/**
		* @brief  ûIPOϢӦ
		* @param[in] info ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_IPO
		*/
		virtual  void TAP_CDECL  OnRspCancelAccountIPO(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode, const ITapTrade::TapAPIAccountIPOCancelRsp *info) {};
		/**
		* @brief  ûIPOϢ֪ͨ
		* @param[in] info ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_IPO
		*/
		virtual  void TAP_CDECL  OnRtnAddAccountIPO(const ITapTrade::TapAPIAccountIPOAddNotice *info) {};
		/**
		* @brief  ûIPOϢ֪ͨ
		* @param[in] info ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
		* @attention Ҫ޸ĺɾinfoָʾݣýЧ
		* @ingroup G_T_IPO
		*/
		virtual  void TAP_CDECL  OnRtnCancelAccountIPO(const ITapTrade::TapAPIAccountIPOCancelNotice *info) {};

		/**
		* @brief  ⶳϢ֤Ӧ
		* @ingroup G_T_UF
		*/
		virtual  void TAP_CDECL  OnRspUnFreezeVerificate(ITapTrade::TAPIUINT32 sessionID, ITapTrade::TAPIINT32 errorCode) {};
	};


	/**
	 * @brief ӿ:TapTradeAPI
	 * @details TapTradeAPI⹦ܽӿڡûԵõĹܺ
	 */
	class ITapTradeAPI
	{
	public:
		/**
		* @brief	APIĻصӿڶ
		* @details	ϵͳAPI֪ͨͨõĻص֪ͨʹߡ
		*			ITapTradeAPINotifyAPIĻصӿڣûҪ̳ʵִ˽ӿûҪĹܡ
		*			ûûûصӿڣAPIûκõϢ\n
		*			ITapTradeAPINotifyϸ鿴TapTradeAPI.h ļ
		* @param[in] apiNotify ʵITapTradeAPINotifyӿڵĶָ롣
		* @note ͬ
		* @ingroup G_T_Login
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL SetAPINotify(ITapTrade::ITapTradeAPINotify *pSpi) = 0;
		/**
		* @brief ÷IPַͶ˿ڡ
		* @details  ԶεöַһõΪַַ֮ΪʱлıַLoginʱַֻ
		* @param[in] IP   IPַ
		* @param[in] port ˿ں
		* @param[in] bSSL ǷΪssl˿
		* @note ͬ
		* @ingroup G_T_Login
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL SetHostAddress(const ITapTrade::TAPICHAR *IP, ITapTrade::TAPIUINT16 port, bool bSSL = false) = 0;

		/**
		* @brief	¼APIӷ񣬽·¼֤
		* @details	ʹúǰûҪɷSetHostAddress()ҴTapAPITradeLoginAuth͵ûϢ
		*			Ҫúûصӿڡ\n
		*			¼нӵķϢͨصOnConnectظû\n
		*			ӽû֤ϢͨصOnRspLogin()ظû\n
		*			¼ɹAPIԶAPIĳʼAPIݣѯԺͨصOnAPIReady()
		*			ָʾûAPIʼɣԽкĲˡ
		*			LoginʱֻӵһεSetHostAddressʱõַ
		*			¼ʧҲ󡢵¼ʱ⣩
		* @param[in] loginAuth ¼֤Ϣṹָ롣¼Ҫ֤Ϣ
		* @retval 0 ¼ɹAPIʼ׼̨
		* @retval 0 
		* @note 첽
		* @attention Login()óɹֻǴڷ·ӣֻлصOnRspLogin()ķָʾûǷɹ¼ˡ
		* @ingroup G_T_Login
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL Login(const ITapTrade::TapAPITradeLoginAuth *loginAuth) = 0;

		/**
		* @brief	̨Ͷ֤
		* @details	¼ɺϵͳҪж֤룬¼ʾҪж֤
		*			˺Ҫ9.2.7̨ݻصOnRtnContactInfoеϵʽѡյַֻ䣩֤룬
		*			յȷӦԵSetVertificateCode ö֤ɵ¼̡
		*			֤ЧֻһΣµ¼
		* @param[out] sessionIDĻỰID
		* @param[in]  ContactInfo,Ҫն֤ϵַֻš
		* @retval 0 ֤ɹ
		* @retval 0 
		* @note 첽
		* @attention úҪڵ¼Ӧ󷵻10003֮áһ֤ЧڣֻɵøúһΡ
		* @ingroup G_T_Login
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL RequestVertificateCode(ITapTrade::TAPIUINT32 *sessionID, ITapTrade::TAPISTR_40 ContactInfo) = 0;
		/**
		* @brief	Ͷ֤֤
		* @details	ҪȵRequestVertificateCode֤룬ֻ䣩յ֤ٵøú֤ɵ¼
		*			¼ɺٵô˺ԭĵ¼ʧҲܵôκ᷵ضӦĴϢ
		*			ô˽ӿںOnRspLogin᷵ص¼Ӧɹıǣɹʾ¼ɣԵȴOnAPIReadyɻص
		*			֤ٴεô˺ȷ֤֤
		*			ʱصɺAPIϿӣҪٴνе¼
		* @param[out]	sessionID ش˴޸ĻỰID;
		* @param[in]	req ޸Ľṹָ롣LoginTypeΪ֤¼ͣLOGINTYPE_NORMAL¼¼ж϶֤Чڡ
		*				LOGINTYPE_TEMPORARYʱ¼´ε¼֤
		* @retval 0 ֤ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_Login
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL SetVertificateCode(ITapTrade::TAPIUINT32 *sessionID, ITapTrade::TapAPISecondCertificationReq *req) = 0;

		/**
		* @brief	Ͽͷ·ӡ
		* @details	úAPIǳϿӡ
		*			ԶҲֹڽеԶ
		* @attention ע⣬̨ӶϿʱŻصOnDisconnect֮ǰѶϿDisconnectʱصOnDisconnect
		* @note 첽
		* @ingroup G_T_Disconnect
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL Disconnect() = 0;
		/**
		* @brief	޸롣
		* @details	ɹû뽫ónewPassword
		* @param[out]	sessionID ش˴޸ĻỰID;
		* @param[in]	req ޸Ľṹָ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_UserInfo
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL ChangePassword(ITapTrade::TAPIUINT32 *sessionID, const ITapTrade::TapAPIChangePasswordReq *req) = 0;

		/**
		* @brief	֤롣
		* @details	Ա֤ĳ˻Ƿȷ
		* @param[out]	sessionID ش˴޸ĻỰID;
		* @param[in]	req ֤Ľṹָ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_UserInfo
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL AuthPassword(ITapTrade::TAPIUINT32 *sessionID, const ITapTrade::TapAPIAuthPasswordReq *req) = 0;

		/**
		* @brief	жϵ¼ûǷĳȨޡ
		* @details	ûȨû¼ʱѾݸAPIԴ˺ִеǱصĲѯ
		* @param[in] rightID ȨID
		* @retval 0 Ȩ
		* @retval 0 Ȩ
		* @note ͬ
		* @ingroup G_T_UserRight
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL HaveCertainRight(ITapTrade::TAPIRightIDType rightID) = 0;
		/**
		* @brief	ѯϵͳ
		* @details	ȡǰգϴνգLMEգLME
		* @param[out]	sessionID ĻỰID;
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_TradeSystem
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL QryTradingDate(ITapTrade::TAPIUINT32 *sessionID) = 0;
		/**
		* @brief	ûԤϢ
		* @details	ûһΪ50ڵַϢ´ε¼ԵõϢ
		*			ҪûȷԼ˺ţҪзα
		* @param[out]	sessionID ĻỰID;
		* @param[in] info	ԤϢַָ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @note ýӿδʵ
		* @ingroup G_T_UserInfo
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL SetReservedInfo(ITapTrade::TAPIUINT32 *sessionID, const ITapTrade::TAPISTR_50 info) = 0;
		/**
		* @brief ѯûʽ˺
		* @details	TapAPIAccQryReqǰʽ˺ŽṹĽṹ壬ûҪʵ˽ṹ壬
		*			ǲҪдṹҪûʽ˺ţʽ˺
		*			ںĺкܶຯҪʹõ
		* @param[out]	sessionID ĻỰID;
		* @param[in]	qryReq ѯûʽ˺ŵĽṹָ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_AccountInfo
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL QryAccount(ITapTrade::TAPIUINT32 *sessionID, const ITapTrade::TapAPIAccQryReq *qryReq) = 0;
		/**
		* @brief	ѯͻʽ
		* @details	TapAPIFundReqҪQryAccount()ȡʽ˺š
		*			Ļصʽ˺ŵʽϢûίгɽʽݵı仯Ҫûʵʱ\n
		*			ѯһοͻʽԶĸÿͻʽ֪ͨ\n
		* @param[out] sessionID ĻỰID;
		* @param[in] qryReq	ѯͻʽĽṹָ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_AccountDetails
		* @attention ÿε¼ýӿֻܽһεáʼʱһΣ֪ͨͨOnRtnFundȡá
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL QryFund(ITapTrade::TAPIUINT32 *sessionID, const ITapTrade::TapAPIFundReq *qryReq) = 0;
		/**
		* @brief ѯϵͳϢ
		* @param[out] sessionID ĻỰID;
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_TradeSystem
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL QryExchange(ITapTrade::TAPIUINT32 *sessionID) = 0;
		/**
		* @brief	ѯϵͳƷϢ
		* @details	ȡеƷϢ
		* @param[out] sessionID ĻỰID;
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_Commodity
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL QryCommodity(ITapTrade::TAPIUINT32 *sessionID) = 0;
		/**
		* @brief	ѯϵͳָƷֵĺԼϢ
		* @details	ʹô˺ǰҪQrycommodity()ȡƷϢ
		*			ȻѡҪƷֽϢTapAPICommodityṹɲѯ
		*			TapAPICommodity򷵻Ϣ
		* @param[out] sessionID ĻỰID;
		* @param[in] qryReq ѯϵͳָƷֵĺԼϢĽṹָ;\n
		*				    òֶΪѡֶΣ·ѯ\n
		*					1.ȫգкԼ\n
		*					2.ЧýƷֵĺԼ\n
		*					3.ƷЧýָƷ͵ĺԼ\n
		*					4.롢ƷͺƷֱ붼ЧƷµкԼ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_Contract
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL QryContract(ITapTrade::TAPIUINT32 *sessionID, const ITapTrade::TapAPICommodity *qryReq) = 0;

		/**
		* @brief	µ
		* @details	ûµĲ
		*			ûµûʽ𡢳ֲ֡ƽ֡ʽ𡢷رǵȶݵı仯ûµĵɽ
		*			жص֪ͨûչʾݵı仯
		* @param[out]	sessionID ĻỰID;
		* @param[out]	ClientOrderNo ؿͻίкš
		* @param[in]	order µίС
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_TradeActions
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL InsertOrder(ITapTrade::TAPIUINT32 *sessionID, ITapTrade::TAPISTR_50 *ClientOrderNo, const ITapTrade::TapAPINewOrder *order) = 0;

		/**
		* @brief	
		* @details	ûίûȫɽ֮ǰʣίС
		* @param[out]	sessionID ĻỰID;
		* @param[in]	order ί
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_TradeActions
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL CancelOrder(ITapTrade::TAPIUINT32 *sessionID, const ITapTrade::TapAPIOrderCancelReq *order) = 0;

		/**
		* @brief	ĵ
		* @details	ûίûȫɽ֮ǰԽиĵ޸ʣδɽίС\n
		*			ûдµί޸ԭδɽĲ֡޸ĻԱѾɽĲ۳ɽ֡
		* @param[out]	sessionID ĻỰID;
		* @param[in]	order ޸ĵί
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_TradeActions
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL AmendOrder(ITapTrade::TAPIUINT32 *sessionID, const ITapTrade::TapAPIAmendOrder *order) = 0;

		/**
		* @brief 
		* @details ûҪʱҪм߸۽ѹĶ
		* @param[out]	sessionID ĻỰID;
		* @param[in]	order ҪĶ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_TradeActions
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL ActivateOrder(TAPIUINT32 * sessionID, const TapAPIOrderActivateReq * order) = 0;

		/**
		* @brief	ѯίϢ
		* @details	صǰίϢԲѯίУҲԲѯδίС\n
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_TradeInfo
		* @attention ÿε¼ýӿֻܽһεáʼʱһΣ֪ͨͨOnRtnOrderȡá
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL QryOrder(ITapTrade::TAPIUINT32 *sessionID, const ITapTrade::TapAPIOrderQryReq *qryReq) = 0;
		/**
		* @brief	ѯίб仯
		* @details	ѯûίеı仯̣ѯίеÿһεı仯
		* @param[out] sessionID ĻỰID;
		* @param[in] qryReq ί̲ѯϢṹָ롣
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_TradeInfo
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL QryOrderProcess(ITapTrade::TAPIUINT32 *sessionID, const ITapTrade::TapAPIOrderProcessQryReq *qryReq) = 0;
		/**
		* @brief ѯɽϢ
		* @details	ѯϵͳгɽϢ
		* @param[out] sessionID ĻỰID;
		* @param[in] qryReq ɽѯϢṹָ롣
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_TradeInfo
		* @attention ÿε¼ýӿֻܽһεáʼʱһΣ֪ͨͨOnRtnFillȡá
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL QryFill(ITapTrade::TAPIUINT32 *sessionID, const ITapTrade::TapAPIFillQryReq *qryReq) = 0;
		/**
		* @brief	ѯûֲ
		* @details	ѯûгֲϢ
		* @param[out] sessionID ĻỰID;
		* @param[in] qryReq	ѯûֲĽṹָ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_TradeInfo
		* @attention ÿε¼ýӿֻܽһεáʼʱһΣ֪ͨͨOnRtnPositionȡá
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL QryPosition(ITapTrade::TAPIUINT32 *sessionID, const ITapTrade::TapAPIPositionQryReq *qryReq) = 0;

		/**
		* @brief	ѯûֲֻ
		* @details	ѯûгֲϢ
		* @param[out] sessionID ĻỰID;
		* @param[in] qryReq	ѯûֲĽṹָ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_TradeInfo
		* @attention ÿε¼ýӿֻܽһεáʼʱһΣ֪ͨͨOnRtnPositionSummaryȡá
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL QryPositionSummary(ITapTrade::TAPIUINT32 *sessionID, const ITapTrade::TapAPIPositionQryReq *qryReq) = 0;

		/**
		* @brief ȡñֵϢ
		* @param[out] sessionID ĻỰID;
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_TradeSystem
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL QryCurrency(ITapTrade::TAPIUINT32 *sessionID) = 0;
		/**
		* @brief ͻʽѯ
		* @param[out] sessionID ĻỰID;
		* @param[in]	Req	ͻʽѯĽṹָ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_HisInfo
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL QryAccountCashAdjust(ITapTrade::TAPIUINT32 *sessionID, const ITapTrade::TapAPIAccountCashAdjustQryReq *qryReq) = 0;
		/**
		* @brief	ȡ׻Ϣ
		* @details	˺ȡ˺ŵĽ׻߷Ϣ׻߷Ϣʶ˺ŵ״̬
		* @param[out] sessionID ĻỰID;
		* @param[in] qryReq ȡ׻ϢĽṹָ;
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		˵ʢӿ
		* @ingroup G_T_AccountDetails
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL QryTradeMessage(ITapTrade::TAPIUINT32 *sessionID, const ITapTrade::TapAPITradeMessageReq *qryReq) = 0;
		/**
		* @brief ѯû˵
		* @param[out]	sessionID ĻỰID;
		* @param[in]	qryReq	ѯʵĽṹָ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_Bill
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL QryBill(ITapTrade::TAPIUINT32 *sessionID, const ITapTrade::TapAPIBillQryReq *qryReq) = 0;
		/**
		* @brief ʷίвѯ
		* @details	ͬѯΪ60
		* @param[out]	sessionID ĻỰID;
		* @param[in]	Req	ʷίвѯĽṹָ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_HisInfo
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL QryHisOrder(ITapTrade::TAPIUINT32 *sessionID, const ITapTrade::TapAPIHisOrderQryReq *qryReq) = 0;
		/**
		* @brief ʷί̲ѯ
		* @details	ͬѯΪ60
		* @param[out] sessionID ĻỰID;
		* @param[in]	Req	ʷί̲ѯĽṹָ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_HisInfo
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL QryHisOrderProcess(ITapTrade::TAPIUINT32 *sessionID, const ITapTrade::TapAPIHisOrderProcessQryReq *qryReq) = 0;
		/**
		* @brief ʷɽѯ
		* @details	ͬѯΪ60
		* @param[out] sessionID ĻỰID;
		* @param[in]	Req	ʷɽѯĽṹָ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_HisInfo
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL QryHisMatch(ITapTrade::TAPIUINT32 *sessionID, const ITapTrade::TapAPIHisMatchQryReq *qryReq) = 0;
		/**
		* @brief ʷֲֲѯ
		* @details	ͬѯΪ60
		* @param[out] sessionID ĻỰID;
		* @param[in]	Req	ʷֲֲѯĽṹָ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_HisInfo
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL QryHisPosition(ITapTrade::TAPIUINT32 *sessionID, const ITapTrade::TapAPIHisPositionQryReq *qryReq) = 0;
		/**
		* @brief ʷѯ
		* @details	ͬѯΪ60
		* @param[out] sessionID ĻỰID;
		* @param[in]	Req	ʷѯĽṹָ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_HisInfo
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL QryHisDelivery(ITapTrade::TAPIUINT32 *sessionID, const ITapTrade::TapAPIHisDeliveryQryReq *qryReq) = 0;

		/**
		* @brief ͻѼѯ
		* @details	ͬѯΪ60
		* @param[out] sessionID ĻỰID;
		* @param[in]	Req	ͻѼѯṹ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_Rent
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL QryAccountFeeRent(ITapTrade::TAPIUINT32 *sessionID, const ITapTrade::TapAPIAccountFeeRentQryReq *qryReq) = 0;
		/**
		* @brief ͻ֤ѯ
		* @details	ͬѯΪ60
		* @param[out] sessionID ĻỰID;
		* @param[in]	Req	ͻ֤ѯṹ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_Rent
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL QryAccountMarginRent(ITapTrade::TAPIUINT32 *sessionID, const ITapTrade::TapAPIAccountMarginRentQryReq *qryReq) = 0;
		/**
		* @brief ۽˫ָ߱
		* @param[out] sessionID صǰSessionID;
		* @param[out] ClientBuyOrderNoظ۽˫߱򵥵Ŀͻίк;
		* @param[out] ClientSellOrderNoظ۽˫߱Ŀͻίк;
		* @param[in] order˫߱ṹ;
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_HKMarket
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL InsertHKMarketOrder(TAPIUINT32 *sessionID, TAPISTR_50 *ClientBuyOrderNo, TAPISTR_50 *ClientSellOrderNo, const TapAPIOrderMarketInsertReq *order) = 0;

		/**
		* @brief ۽˫ָ߳
		* @param[out] sessionID صǰsessionID
		* @param[in] order ۽ָ̳ṹ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_HKMarket
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL CancelHKMarketOrder(TAPIUINT32 *sessionID, const TapAPIOrderMarketDeleteReq *order) = 0;

		/**
		* @brief ɾָ
		* @param[out] sessionID صǰsessionID
		* @param[in] order ҪɾĶ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_LocalActions
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL OrderLocalRemove(TAPIUINT32 *sessionID, const TapAPIOrderLocalRemoveReq *order) = 0;
		/**
		* @brief ¼ָ
		* @param[out] sessionID صǰsessionID
		* @param[in] order ¼Ϣ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_LocalActions
		*/
		virtual  ITapTrade::TAPIINT32 TAP_CDECL OrderLocalInput(TAPIUINT32 *sessionID, const TapAPIOrderLocalInputReq *order) = 0;
		/**
		* @brief ޸ָ
		* @param[out] sessionID صǰsessionID
		* @param[in] order ޸ṹ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_LocalActions
		*/
		virtual  ITapTrade::TAPIINT32 TAP_CDECL OrderLocalModify(TAPIUINT32 *sessionID, const TapAPIOrderLocalModifyReq *order) = 0;
		/**
		* @brief  תָ
		* @param[out] sessionID صǰsessionID
		* @param[in] תϢ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_LocalActions
		*/
		virtual  ITapTrade::TAPIINT32 TAP_CDECL OrderLocalTransfer(TAPIUINT32 *sessionID, const TapAPIOrderLocalTransferReq *order) = 0;
		/**
		* @brief ɽ¼ָ
		* @param[out] sessionID صǰsessionID
		* @param[in] Ҫ¼ĳɽϢ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_LocalActions
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL FillLocalInput(TAPIUINT32 *sessionID, const TapAPIFillLocalInputReq *fill) = 0;
		/**
		* @brief ɽɾָ
		* @param[out] sessionID صǰsessionID
		* @param[in] ɽɾϢ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_LocalActions
		*/
		virtual ITapTrade::TAPIINT32 TAP_CDECL FillLocalRemove(TAPIUINT32 *sessionID, const TapAPIFillLocalRemoveReq *fill) = 0;

		/**
		* @brief ͻֻѯ
		* @param[out] sessionID صǰsessionID
		* @param[in] ͻֻѯϢ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽,ϵͳɵ
		* @ingroup G_T_Spot
		*/
		virtual  ITapTrade::TAPIINT32 TAP_CDECL QrySpotLock(TAPIUINT32 *sessionID, const TapAPISpotLockQryReq *qryReq) = 0;

		/**
		* @brief ύɼϢ-м̷ʽ
		* @details ʽҪύɼϢֱʽڵ½̻ԶύɼϢ
				   м̷ʽҪAPIready֮ô˺ϱͻɼϢ
		* @param[out] sessionID صǰsessionID
		* @param[in] мģʽ£ϱ¼ĲɼϢ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽,ϵͳɵ
		* @ingroup G_T_Spot
		*/
		virtual  ITapTrade::TAPIINT32 TAP_CDECL SubmitUserLoginInfo(TAPIUINT32 *sessionID, const TapAPISubmitUserLoginInfo *qryReq) = 0;

		/**
		* @brief ҵָ
		* @details ûҵָ󣬻һӦͶ֪ͨûչʾݵı仯
		* @param[out]	sessionID ĻỰID;
		* @param[out]	ClientOrderNo ؿͻίкš
		* @param[in]	order µҵָ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽,ϵͳɵ
		* @ingroup G_T_Spot
		*/
		virtual  ITapTrade::TAPIINT32 TAP_CDECL InsertSpecialOrder(TAPIUINT32 *sessionID, TAPISTR_50 *clientorderno, const TapAPISpecialOrderInsertReq *order) = 0;

		/**
		* @brief ѯҵίϢ
		* @param[out] sessionID صǰsessionID
		* @param[in]  qryReq ҵίвѯṹ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽,ϵͳɵ
		* @ingroup G_T_Spot
		*/
		virtual  ITapTrade::TAPIINT32 TAP_CDECL QrySpecialOrder(TAPIUINT32 *sessionID, const TapAPISpecialOrderQryReq *qryReq) = 0;

		/**
		* @brief ѯûϲԳֲ
		* @param[out] sessionID صǰsessionID
		* @param[in]  qryReq ϲԳֲֲѯṹ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽,ϵͳɵ
		* @ingroup G_T_Spot
		*/
		virtual  ITapTrade::TAPIINT32 TAP_CDECL QryCombinePosition(TAPIUINT32 *sessionID, const TapAPICombinePositionQryReq *qryReq) = 0;

		/**
		* @brief ѯû豸
		* @details ֻصǰûԼ豸
		* @param[out] sessionID صǰsessionID
		* @param[in]  qryReq û豸ѯṹ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_TrustDevice
		*/
		virtual  ITapTrade::TAPIINT32 TAP_CDECL QryUserTrustDevice(TAPIUINT32 *sessionID, const TapAPIUserTrustDeviceQryReq *qryReq) = 0;
		/**
		* @brief û豸
		* @details	APIԶȡǰ¼ûȨ롢MAC豸ƣ̨豸ӡ
		* @param[out] sessionID صǰsessionID
		* @param[in]  qryReq û豸ӽṹ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_TrustDevice
		*/
		virtual  ITapTrade::TAPIINT32 TAP_CDECL AddUserTrustDevice(TAPIUINT32 *sessionID, const TapAPIUserTrustDeviceAddReq *qryReq) = 0;
		/**
		* @brief ɾû豸
		* @details ֻɾǰûԼ豸
		* @param[out] sessionID صǰsessionID
		* @param[in]  qryReq û豸ɾṹ
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_TrustDevice
		*/
		virtual  ITapTrade::TAPIINT32 TAP_CDECL DelUserTrustDevice(TAPIUINT32 *sessionID, const TapAPIUserTrustDeviceDelReq *qryReq) = 0;

		/**
		* @brief ѯIPOϢ
		* @details ѯȫIPOϢ
		* @param[out] sessionID صǰsessionID
		* @param[in]  qryReq
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @attention ۹ϵͳʹãϵͳɵ
		* @ingroup G_T_IPO
		*/
		virtual  ITapTrade::TAPIINT32 TAP_CDECL QryIPOInfo(TAPIUINT32 *sessionID, const TapAPIIPOInfoQryReq *qryReq) = 0;
		/**
		* @brief ѯIPO깺
		* @details ѯ󲻿ա깺ʱ깺ֻڿ깺ѡ
		* @param[out] sessionID صǰsessionID
		* @param[in]  qryReq
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @attention ۹ϵͳʹãϵͳɵ
		* @ingroup G_T_IPO
		*/
		virtual  ITapTrade::TAPIINT32 TAP_CDECL QryIPOStockQty(TAPIUINT32 *sessionID, const TapAPIAvailableApplyQryReq *qryReq) = 0;
		/**
		* @brief ѯͻ걨IPOϢ
		* @details ѯͻ걨IPOϢղС
		* @param[out] sessionID صǰsessionID
		* @param[in]  qryReq
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @attention ۹ϵͳʹãϵͳɵ
		* @ingroup G_T_IPO
		*/
		virtual  ITapTrade::TAPIINT32 TAP_CDECL QryAccountIPO(TAPIUINT32 *sessionID, const TapAPIAccountIPOQryReq *qryReq) = 0;
		/**
		* @brief ͻ깺IPO
		* @details ͻ깺IPOҪƷ֡깺͡깺ʱ
		* APIԶѣʱԶϢʽ
		* ʽΪ = ۼ**ʱ깺 = ۼ* -ʽϢ = /360**ʽ
		* ֽ깺ʱ= IPOѣ깺ʱ = IPO + ѣ
		* ⣬깺ǷϿ깺IPOƷǷڣʽʱǷߡֻ깺ΪʱʱЧ
		* @param[out] sessionID صǰsessionID
		* @param[in]  qryReq
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @attention ۹ϵͳʹãϵͳɵ
		* @ingroup G_T_IPO
		*/
		virtual  ITapTrade::TAPIINT32 TAP_CDECL AddAccountIPO(TAPIUINT32 *sessionID, const TapAPIAccountIPOAddReq *qryReq) = 0;
		/**
		* @brief ͻ깺IPO
		* @details ͻIPOϢͻύIPO״̬Ϊѳ,ɾ¼
		* @param[out] sessionID صǰsessionID
		* @param[in]  qryReq
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @attention ۹ϵͳʹãϵͳɵ
		* @ingroup G_T_IPO
		*/
		virtual  ITapTrade::TAPIINT32 TAP_CDECL CancelAccountIPO(TAPIUINT32 *sessionID, const TapAPIAccountIPOCancelReq *qryReq) = 0;

		/**
		* @brief ʼⶳ
		* @details ˻ѶᣬᡣⶳΪ:
		* 1.UnFreezeյ¼ӦOnRspLogin롰TAPIERROR_LOGIN_UNFREEZEⶳ޷ⶳ
		* 2.VerificateUnFreezeInfoյOnRspUnFreezeVerificateΪ0֤ɹ
		* 3.RequestVertificateCodeϵϢдVerificateUnFreezeInfoдֻţյOnRspRequestVertificateCodeɹ
		* 4.SetVertificateCodeյOnRspLoginΪTAPIERROR_UNFREEZE_SUCCESS˻ⶳɹӶϿ֮µ¼
		* @param[out] sessionID صǰsessionID
		* @param[in]  qryReq
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_UF
		*/
		virtual  ITapTrade::TAPIINT32 TAP_CDECL UnFreeze(const TapAPITradeLoginAuth *loginAuth) = 0;
		/**
		* @brief ⶳϢ֤
		* @details ֤֤䡢ֻš֤ȫɹ󣬿Խһ֤
		* @param[out] sessionID صǰsessionID
		* @param[in]  qryReq
		* @retval 0 ɹ
		* @retval 0 
		* @note 첽
		* @ingroup G_T_UF
		*/
		virtual  ITapTrade::TAPIINT32 TAP_CDECL VerificateUnFreezeInfo(TAPIUINT32 *sessionID, const TapAPIVerifyIdentityReq *qryReq) = 0;


	};
};

//-----------------------------TapTradeAPI------------------------------------


#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

	/**
	* @brief	TapTradeAPIĽӿڶ
	* @details	APIĽӿ
	*			ʱAPIԶTapAPIApplicationInfoĲãÿ趨ֵһΣﵽ趨ֵлһַ
	*			еַл󣬻صһַѭDisconnectֹ
	*			ʱ޷¼޷õַջ²ѯرأӳɹ¼ʧܣ
	* @param[in] appInfo ӦóϢ
	* @param[in] iResult ӿڵĴ롣
	* @retval NULL	ʧܣԭͨiResultжϡ
	* @retval !NULL	ʵITapTradeAPIӿڵĶָ롣
	* @ingroup G_T_API
	*/
	TAP_DLLEXPORT ITapTrade::ITapTradeAPI *TAP_CDECL CreateITapTradeAPI(const ITapTrade::TapAPIApplicationInfo *appInfo, ITapTrade::TAPIINT32 &iResult);
	/**
	* @brief	ͨCreateTapTradeAPIITapTradeAPI
	* @param[in] apiObj ITapTradeAPIָ롣
	* @ingroup G_T_API
	*/
	TAP_DLLEXPORT void TAP_CDECL FreeITapTradeAPI(ITapTrade::ITapTradeAPI *apiObj);
	/**
	* @brief	ȡTapTradeAPIİ汾Ϣ
	* @ingroup G_T_API
	*/
	TAP_DLLEXPORT const ITapTrade::TAPICHAR *TAP_CDECL GetITapTradeAPIVersion();

	/**
	* @brief	ݴȡϢڴAPIָ󼴿ɵã򷵻ؿֵ
	* @details	ݴԻȡӦĴϢ
	* @param[in]	errorCode 
	* @retval شϢ
	* @note ͬ
	* @ingroup G_T_API
	*/
	TAP_DLLEXPORT const char  * TAP_CDECL GetITapErrorDescribe(ITapTrade::TAPIINT32 errorCode);


	//ע͵ƶAPIָĲߣڴAPIָʱ򴴽APIRun־־
	/**
	* @brief	APIĿ¼
	* @details	\n
	*			ûдļ»ͼļ\n
	*			ļбΪAPIյҪݺAPIʹúʹ־
	* @param[in] path Ŀ¼ãĿ¼WindowΪ\\ߡ/, LinuxΪ/
	* @retval 0 ɹ
	* @retval 0 
	* @note ͬ
	* @ingroup G_T_LogConfig
	*/
	//	TAP_DLLEXPORT ITapTrade::TAPIINT32 TAP_CDECL SetITapTradeAPIDataPath(const ITapTrade::TAPICHAR *path);
	/**
	* @brief	API־
	* @details	趨־ֻеʵ־˴趨ļͬʱŻὫ־дSetTapTradeAPIDataPath()򿪵־ļ\n
	* @param[in]	level ־\n
	*					APILOGLEVEL_NONE	¼־\n
	*					APILOGLEVEL_ERROR	¼Error־\n
	*					APILOGLEVEL_WARNING	¼ErrorWarning־\n
	*					APILOGLEVEL_DEBUG	¼ErrorWarningDebug־\n
	* @retval 0 趨ɹ
	* @retval 0 
	* @note ͬ
	* @ingroup G_T_LogConfig
	*/
	//TAP_DLLEXPORT ITapTrade::TAPIINT32 TAP_CDECL SetITapTradeAPILogLevel(ITapTrade::TAPILOGLEVEL level);


#ifdef __cplusplus
}
#endif // __cplusplus


#endif // TAP_TRADE_API_H