#ifndef TAP_QUOTE_API_H
#define TAP_QUOTE_API_H

#include "TapQuoteAPIDataType.h"

#ifdef _WIN32
#define TAP_CDECL  __cdecl
#define TAP_DLLEXPORT __declspec(dllexport)
#else
#define TAP_CDECL
#define TAP_DLLEXPORT
#endif

//TapQuoteAPI.h
//ļTapQuoteAPIṩߵĶӿڡͻصӿڡ

//TapQuoteAPI Ļص֪ͨӿڡ
class ITapQuoteAPINotify
{
public:
	/**
	* @brief	ϵͳ¼̻ص
	* @details	˺ΪLogin()¼ĻصLogin()ɹ·ӣȻAPI͵¼֤Ϣ
	*			¼ڼݷ͵¼ĻϢݵ˻صС
	* @param[in] errorCode ش,0ʾɹ
	* @param[in] info ½ӦϢerrorCode!=0info=NULL
	* @attention	ûصسɹ˵û¼ɹǲAPI׼ϡҪȵOnAPIReadyܽвѯ붩
	* @ingroup G_Q_Login
	*/
	virtual void TAP_CDECL OnRspLogin(TAPIINT32 errorCode, const TapAPIQuotLoginRspInfo *info) = 0;
	/**
	* @brief	֪ͨûAPI׼
	* @details	ֻûصյ˾֪ͨʱܽкĸݲѯ\n
	*			˻صAPIܷı־
	* @attention  ſԽк
	* @ingroup G_Q_Login
	*/
	virtual void TAP_CDECL OnAPIReady() = 0;
	/**
	* @brief	APIͷʧȥӵĻص
	* @details	APIʹù߱ʧȥӺ󶼻ᴥ˻ص֪ͨûѾϿ
	* @param[in] reasonCode Ͽԭ롣ԭμб \n
	* @ingroup G_Q_Disconnect
	*/
	virtual void TAP_CDECL OnDisconnect(TAPIINT32 reasonCode) = 0;
	/**
	* @brief	ƷϢ
	* @details	˻صӿûصõƷϢ
	* @param[in] sessionID ĻỰID
	* @param[in] errorCode 룬errorCode!=0ʱ,infoΪNULL
	* @param[in] isLast ʾǷһݣ
	* @param[in] info صϢʼָ롣
	* @attention  Ҫ޸ĺɾinfoָʾݣýЧ
	* @ingroup G_Q_Commodity
	*/
	virtual void TAP_CDECL OnRspQryCommodity(TAPIUINT32 sessionID, TAPIINT32 errorCode, TAPIYNFLAG isLast, const TapAPIQuoteCommodityInfo *info) = 0;
	/**
	* @brief ϵͳкԼϢ
	* @param[in] sessionID ĻỰID
	* @param[in] errorCode 룬errorCode!=0ʱ,infoΪNULL
	* @param[in] isLast ʾǷһݣ
	* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
	* @attention Ҫ޸ĺɾinfoָʾݣýЧ
	* @ingroup G_Q_Contract
	*/
	virtual void TAP_CDECL OnRspQryContract(TAPIUINT32 sessionID, TAPIINT32 errorCode, TAPIYNFLAG isLast, const TapAPIQuoteContractInfo *info) = 0;
	/**
	* @brief	ضȫġ
	* @details	˻صӿضȫġȫΪǰʱϢ
	* @param[in] sessionID ĻỰID
	* @param[in] isLast ʾǷһݣ
	* @param[in] errorCode 룬errorCode!=0ʱ,infoΪNULL
	* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
	* @attention  Ҫ޸ĺɾinfoָʾݣýЧ
	* @ingroup G_Q_Quote
	*/
	virtual void TAP_CDECL OnRspSubscribeQuote(TAPIUINT32 sessionID, TAPIINT32 errorCode, TAPIYNFLAG isLast, const TapAPIQuoteWhole *info) = 0;
	/**
	* @brief ˶ָԼĽص
	* @param[in] sessionID ĻỰID
	* @param[in] errorCode 룬errorCode!=0ʱ,infoΪNULL
	* @param[in] isLast ʾǷһݣ
	* @param[in] info		ָ򷵻صϢṹ塣errorCodeΪ0ʱinfoΪա
	* @attention  Ҫ޸ĺɾinfoָʾݣýЧ
	* @ingroup G_Q_Quote
	*/
	virtual void TAP_CDECL OnRspUnSubscribeQuote(TAPIUINT32 sessionID, TAPIINT32 errorCode, TAPIYNFLAG isLast, const TapAPIContract *info) = 0;
	/**
	* @brief	ضı仯ݡ
	* @details	˻صӿ֪ͨûϢ˱仯ûύµȫġ
	* @param[in] info µȫ
	* @attention Ҫ޸ĺɾQuoteָʾݣýЧ
	* @ingroup G_Q_Quote
	*/
	virtual void TAP_CDECL OnRtnQuote(const TapAPIQuoteWhole *info) = 0;
};

//TapQuoteAPI ⹦ܽӿڡûԵõĹܺ
class ITapQuoteAPI
{
public:
	/**
	* @brief	APIĻصӿڶ
	* @details	ϵͳAPI֪ͨͨõĻص֪ͨʹߡ
	*			ITapQuoteAPINofifyAPIĻصӿڣûҪ̳ʵִ˽ӿûҪĹܡ
	*			ûûûصӿڣAPIûκõϢ\n
	*			ITapQuoteAPINotifyϸ鿴TapQuoteAPI.h ļ
	* @param[in] apiNotify ʵITapQuoteAPINotifyӿڵĶָ롣
	* @operationtype ͬ
	* @ingroup G_Q_Login
	*/
	virtual TAPIINT32 TAP_CDECL SetAPINotify(ITapQuoteAPINotify *apiNotify) = 0;
	/**
	* @brief ÷IPַͶ˿ڡȵLoginʱӡ
	* @param[in] IP   IPַ
	* @param[in] port ˿ں
	* @operationtype ͬ
	* @ingroup G_Q_Login
	*/
	virtual TAPIINT32 TAP_CDECL SetHostAddress(const TAPICHAR *IP, TAPIUINT16 port) = 0;
	/**
	* @brief	¼APIӷ񣬽·¼֤
	* @details	ʹúǰûҪɷSetHostAddress()ҴTapAPIQuoteLoginAuth͵ûϢ
	*			Ҫúûصӿڡ\n
	*			ӽû֤ϢͨصOnLogin()ظû\n
	*			¼ɹAPIԶAPIĳʼAPIݣѯԺͨصOnAPIReady()
	*			ָʾûAPIʼɣԽкĲˡ
	* @param[in] loginAuth ¼֤Ϣṹָ롣¼Ҫ֤Ϣ
	* @retval 0 ¼ɹAPIʼ׼̨
	* @retval 0 
	* @attention ¼ɹҪOnLoginصжϡ
	* @operationtype 첽
	* @warning	Login()óɹֻǴڷ·ӣֻлصOnLogin()ķָʾûǷɹ¼ˡ
	* @ingroup G_Q_Login
	*/
	virtual TAPIINT32 TAP_CDECL Login(const TapAPIQuoteLoginAuth *loginAuth) = 0;
	/**
	* @brief	Ͽͷ·ӡ
	* @details	úAPIǳϿӡ
	* @operationtype 첽
	* @ingroup G_Q_Disconnect
	*/
	virtual TAPIINT32 TAP_CDECL Disconnect() = 0;
	/**
	* @brief õƷ
	* @param[out] sessionID ĻỰID
	* @retval 0 ɹ
	* @retval 0 
	* @operationtype 첽
	* @ingroup G_Q_Commodity
	*/
	virtual TAPIINT32 TAP_CDECL QryCommodity(TAPIUINT32 *sessionID) = 0;
	/**
	* @brief	ѯϵͳָƷֵĺԼϢ
	* @details	ʹô˺ǰҪQryCommodity()ȡƷϢ
	*			ȻѡҪƷֽϢTapAPICommodityṹɲѯ
	* @param[out] sessionID ĻỰID;
	* @param[in] qryReq ѯϵͳָƷֵĺԼϢĽṹָ;\n
	*				    òֶΪѡֶΣ·ѯ\n
	*					1.ȫգкԼ\n
	*					2.ЧýƷֵĺԼ\n
	*					3.ƷЧýָƷ͵ĺԼ\n
	*					4.롢ƷͺƷֱ붼ЧƷµкԼ
	* @retval 0 ɹ
	* @retval 0 
	* @operationtype 첽
	* @ingroup G_Q_Contract
	*/
	virtual TAPIINT32 TAP_CDECL QryContract(TAPIUINT32 *sessionID, const TapAPICommodity *qryReq) = 0;
	/**
	* @brief	ָԼ
	* @details	contractĺԼϢ鶩ĳɹûϢ
	*			ֱû˶Ϣ߶Ͽڷͨš\n
	*			ô˺ǰȻȡԼϢȻӺԼϢȡԼcontract\n
	* @param[out] sessionID ĻỰID
	* @param[in] contract ָԼ
	* @retval 0 ɹ
	* @retval 0 
	* @operationtype 첽
	* @ingroup G_Q_Quote
	*/
	virtual TAPIINT32 TAP_CDECL SubscribeQuote(TAPIUINT32 *sessionID, const TapAPIContract *contract) = 0;
	/**
	* @brief	˶ָԼ
	* @details	˶ѾĵϢ
	* @param[out] sessionID ĻỰID
	* @param[in]	contract ָԼ
	* @retval 0 ɹ
	* @retval 0 
	* @operationtype 첽
	* @ingroup G_Q_Quote
	*/
	virtual TAPIINT32 TAP_CDECL UnSubscribeQuote(TAPIUINT32 *sessionID, const TapAPIContract *contract) = 0;
};

//-----------------------------TapQuoteAPI------------------------------------


#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

/**
* @brief	TapQuoteAPIĽӿڶ
* @details	APIĽӿ
* @param[in] appInfo ӦóϢ
* @param[in] iResult ӿڵĴ롣
* @retval NULL	ʧܡ
* @retval !NULL	ʵITapQuoteAPIӿڵĶָ롣
* @ingroup G_Q_API
*/
TAP_DLLEXPORT ITapQuoteAPI *TAP_CDECL CreateTapQuoteAPI(const TapAPIApplicationInfo *appInfo, TAPIINT32 &iResult);
/**
* @brief	ͨCreateTapQuoteAPIITapQuoteAPI
* @param[in] apiObj ITapQuoteAPIָ롣
* @ingroup G_Q_API
*/
TAP_DLLEXPORT void TAP_CDECL FreeTapQuoteAPI(ITapQuoteAPI *apiObj);
/**
* @brief	ȡTapQuoteAPIİ汾Ϣ
* @ingroup G_Q_API
*/
TAP_DLLEXPORT const TAPICHAR *TAP_CDECL GetTapQuoteAPIVersion();
/**
* @brief	APIĿ¼
* @details	úͬʱpathĿ¼´գʽTapQuoteAPI[YYYYMMDD].log)ļ\n
*			ûдļ»ͼļ\n
*			ļбΪAPIյҪݺAPIʹúʹ־
* @param[in] path Ŀ¼ãĿ¼WindowΪ\\ߡ/, LinuxΪ/
* @retval 0 ɹ
* @retval 0 
* @operationtype ͬ
* @ingroup G_Q_LogConfig
*/
TAP_DLLEXPORT TAPIINT32 TAP_CDECL SetTapQuoteAPIDataPath(const TAPICHAR *path);
/**
* @brief	API־
* @details	趨־ֻеʵ־˴趨ļͬʱŻὫ־дSetTapQuoteAPIDataPath()򿪵־ļ\n
* @param[in]	level ־\n
*					APILOGLEVEL_NONE	¼־\n
*					APILOGLEVEL_ERROR	¼Error־\n
*					APILOGLEVEL_WARNING	¼ErrorWarning־\n
*					APILOGLEVEL_DEBUG	¼ErrorWarningDebug־\n
* @retval 0 趨ɹ
* @retval 0 
* @operationtype ͬ
* @ingroup G_Q_LogConfig
*/
TAP_DLLEXPORT TAPIINT32 TAP_CDECL SetTapQuoteAPILogLevel(TAPILOGLEVEL level);

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // TAP_QUOTE_API_H